/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.NullLockProvider;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.ResourceStore;

final class NullResourceStore
implements ResourceStore {
    final long MODIFIED = System.currentTimeMillis();
    final LockProvider locks = new NullLockProvider();

    NullResourceStore() {
    }

    @Override
    public Resource get(final String resourcePath) {
        return new Resource(){
            String path;
            {
                this.path = resourcePath;
            }

            @Override
            public String path() {
                return this.path;
            }

            @Override
            public String name() {
                return Paths.name(this.path);
            }

            @Override
            public InputStream in() {
                throw new IllegalStateException("Unable to read from ResourceStore.EMPTY");
            }

            @Override
            public Resource.Lock lock() {
                return NullResourceStore.this.locks.acquire(this.path);
            }

            @Override
            public void addListener(ResourceListener listener) {
            }

            @Override
            public void removeListener(ResourceListener listener) {
            }

            @Override
            public OutputStream out() {
                throw new IllegalStateException("Unable to write to ResourceStore.EMPTY");
            }

            @Override
            public File file() {
                throw new IllegalStateException("No file access to ResourceStore.EMPTY");
            }

            @Override
            public File dir() {
                throw new IllegalStateException("No directory access to ResourceStore.EMPTY");
            }

            @Override
            public long lastmodified() {
                return NullResourceStore.this.MODIFIED;
            }

            @Override
            public Resource parent() {
                return ResourceStore.EMPTY.get(Paths.parent(this.path));
            }

            @Override
            public Resource get(String resourcePath2) {
                return ResourceStore.EMPTY.get(Paths.path(this.path, resourcePath2));
            }

            @Override
            public List<Resource> list() {
                return Collections.emptyList();
            }

            @Override
            public Resource.Type getType() {
                return Resource.Type.UNDEFINED;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Resource other = (Resource)obj;
                return !(this.path == null ? other.path() != null : !this.path.equals(other.path()));
            }

            public String toString() {
                return this.path;
            }

            @Override
            public boolean delete() {
                return false;
            }

            @Override
            public boolean renameTo(Resource dest) {
                return false;
            }
        };
    }

    public String toString() {
        return "NullResourceStore";
    }

    @Override
    public boolean remove(String path) {
        return false;
    }

    @Override
    public boolean move(String path, String target) {
        return false;
    }
}

