/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.FileSystemWatcher;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.Resources;
import org.geotools.data.DataUtilities;
import org.geotools.util.logging.Logging;

public final class Files {
    private static final Logger LOGGER = Logging.getLogger(Files.class);
    static final FileSystemWatcher watcher = new FileSystemWatcher();

    private Files() {
    }

    public static File url(File baseDirectory, String url) {
        if (url.startsWith("file:/")) {
            try {
                return DataUtilities.urlToFile((URL)new URL(url));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (url.startsWith("file:")) {
            File f = new File(url = url.substring(5));
            if (f.isAbsolute() || f.exists()) {
                return f;
            }
            if (baseDirectory != null) {
                return new File(baseDirectory, url);
            }
            return f;
        }
        File file = new File(url);
        if (file.isAbsolute() || file.exists()) {
            return file;
        }
        if (baseDirectory != null && (file = new File(baseDirectory, url)).exists()) {
            return file;
        }
        return null;
    }

    public static Resource asResource(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File required");
        }
        if (!file.exists()) {
            // empty if block
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File required (not a directory)");
        }
        return new ResourceAdaptor(file);
    }

    public static void schedule(long delay, TimeUnit unit) {
        watcher.schedule(delay, unit);
    }

    public static OutputStream out(final File file) throws FileNotFoundException {
        final File temp = new File(file.getParentFile(), file.getName() + ".tmp");
        if (temp.exists()) {
            temp.delete();
        }
        return new OutputStream(){
            FileOutputStream delegate;
            {
                this.delegate = new FileOutputStream(temp);
            }

            @Override
            public void close() throws IOException {
                this.delegate.close();
                Files.move(temp, file);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.delegate.write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
                this.delegate.flush();
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.delegate.write(b);
            }

            @Override
            public void write(int b) throws IOException {
                this.delegate.write(b);
            }
        };
    }

    public static boolean move(File source, File dest) throws IOException {
        if (source == null || !source.exists()) {
            throw new NullPointerException("File source required");
        }
        if (dest == null) {
            throw new NullPointerException("File dest required");
        }
        if (source.getCanonicalPath().equalsIgnoreCase(dest.getCanonicalPath())) {
            return true;
        }
        boolean win = System.getProperty("os.name").startsWith("Windows");
        if (win && dest.exists() && !dest.delete()) {
            throw new IOException("Failed to move " + source.getAbsolutePath() + " - unable to remove existing: " + dest.getCanonicalPath());
        }
        if (!source.renameTo(dest)) {
            throw new IOException("Failed to move " + source.getAbsolutePath() + " to " + dest.getAbsolutePath());
        }
        return true;
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            Files.emptyDirectory(file);
        }
        return file.delete();
    }

    private static boolean emptyDirectory(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " does not appear to be a directory at all...");
        }
        boolean allClean = true;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                allClean &= Files.delete(files[i]);
                continue;
            }
            if (files[i].delete()) continue;
            LOGGER.log(Level.WARNING, "Could not delete {0}", files[i].getAbsolutePath());
            allClean = false;
        }
        return allClean;
    }

    static final class ResourceAdaptor
    implements Resource {
        final File file;

        private ResourceAdaptor(File file) {
            this.file = file;
        }

        @Override
        public String path() {
            return Paths.convert(this.file.getPath());
        }

        @Override
        public String name() {
            return this.file.getName();
        }

        @Override
        public Resource.Lock lock() {
            return new Resource.Lock(){

                @Override
                public void release() {
                }
            };
        }

        @Override
        public void addListener(ResourceListener listener) {
            watcher.addListener(this.file, this.path(), listener);
        }

        @Override
        public void removeListener(ResourceListener listener) {
            watcher.removeListener(this.file, this.path(), listener);
        }

        @Override
        public InputStream in() {
            try {
                this.file.createNewFile();
                return new FileInputStream(this.file);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream out() {
            File temp;
            ResourceAdaptor resourceAdaptor = this;
            synchronized (resourceAdaptor) {
                UUID uuid;
                File tryTemp;
                do {
                    uuid = UUID.randomUUID();
                } while ((tryTemp = new File(this.file.getParentFile(), String.format("%s.%s.tmp", this.file.getName(), uuid))).exists());
                temp = tryTemp;
            }
            try {
                temp.createNewFile();
                return new OutputStream(){
                    FileOutputStream delegate;
                    {
                        this.delegate = new FileOutputStream(temp);
                    }

                    @Override
                    public void close() throws IOException {
                        this.delegate.close();
                        if (temp.exists()) {
                            Files.move(temp, ResourceAdaptor.this.file);
                        }
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        this.delegate.write(b, off, len);
                    }

                    @Override
                    public void flush() throws IOException {
                        this.delegate.flush();
                    }

                    @Override
                    public void write(byte[] b) throws IOException {
                        this.delegate.write(b);
                    }

                    @Override
                    public void write(int b) throws IOException {
                        this.delegate.write(b);
                    }
                };
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Could not create temporary file {0} writing directly to {1} instead.", new Object[]{temp, this.file});
                try {
                    this.file.createNewFile();
                    return new FileOutputStream(this.file);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        @Override
        public File file() {
            return this.file;
        }

        @Override
        public File dir() {
            throw new IllegalStateException("Resource adaptor cannot be used to create directory");
        }

        @Override
        public long lastmodified() {
            return this.file.lastModified();
        }

        @Override
        public Resource parent() {
            throw new IllegalStateException("Resource adaptor dos not support parent()");
        }

        @Override
        public Resource get(String resourcePath) {
            throw new IllegalStateException();
        }

        @Override
        public List<Resource> list() {
            return Collections.emptyList();
        }

        @Override
        public Resource.Type getType() {
            return this.file.exists() ? Resource.Type.RESOURCE : Resource.Type.UNDEFINED;
        }

        public String toString() {
            return "ResourceAdaptor(" + this.file + ")";
        }

        @Override
        public boolean delete() {
            return Files.delete(this.file);
        }

        @Override
        public boolean renameTo(Resource dest) {
            if (dest instanceof FileSystemResourceStore.FileSystemResource) {
                return this.file.renameTo(((FileSystemResourceStore.FileSystemResource)dest).file);
            }
            if (dest instanceof ResourceAdaptor) {
                return this.file.renameTo(((ResourceAdaptor)dest).file);
            }
            return Resources.renameByCopy(this, dest);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceAdaptor other = (ResourceAdaptor)obj;
            return !(this.file == null ? other.file != null : !this.file.equals(other.file));
        }
    }
}

