/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.geoserver.platform.resource.FileSystemWatcher;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.NullLockProvider;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.platform.resource.Resources;

public class FileSystemResourceStore
implements ResourceStore {
    protected LockProvider lockProvider = new NullLockProvider();
    protected File baseDirectory = null;
    protected FileSystemWatcher watcher;

    protected FileSystemResourceStore() {
    }

    public LockProvider getLockProvider() {
        return this.lockProvider;
    }

    public void setLockProvider(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }

    public FileSystemResourceStore(File resourceDirectory) {
        boolean create;
        if (resourceDirectory == null) {
            throw new NullPointerException("root resource directory required");
        }
        if (resourceDirectory.isFile()) {
            throw new IllegalArgumentException("Directory required, file present at this location " + resourceDirectory);
        }
        if (!resourceDirectory.exists() && !(create = resourceDirectory.mkdirs())) {
            throw new IllegalArgumentException("Unable to create directory " + resourceDirectory);
        }
        if (!resourceDirectory.exists() || !resourceDirectory.isDirectory()) {
            throw new IllegalArgumentException("Unable to acess directory " + resourceDirectory);
        }
        this.baseDirectory = resourceDirectory;
    }

    public synchronized void addListener(File file, String path, ResourceListener listener) {
        if (this.watcher == null) {
            this.watcher = new FileSystemWatcher();
        }
        this.watcher.addListener(file, path, listener);
    }

    public synchronized void removeListener(File file, String path, ResourceListener listener) {
        if (this.watcher != null) {
            this.watcher.removeListener(file, path, listener);
        }
    }

    @Override
    public Resource get(String path) {
        path = Paths.valid(path);
        return new FileSystemResource(path);
    }

    @Override
    public boolean remove(String path) {
        path = Paths.valid(path);
        File file = Paths.toFile(this.baseDirectory, path);
        return Files.delete(file);
    }

    @Override
    public boolean move(String path, String target) {
        path = Paths.valid(path);
        target = Paths.valid(target);
        File file = Paths.toFile(this.baseDirectory, path);
        File dest = Paths.toFile(this.baseDirectory, target);
        if (!file.exists() && !dest.exists()) {
            return true;
        }
        try {
            dest.getParentFile().mkdirs();
            return Files.move(file, dest);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to move " + path + " to " + target, e);
        }
    }

    public String toString() {
        return "ResourceStore " + this.baseDirectory;
    }

    class FileSystemResource
    implements Resource {
        String path;
        File file;

        public FileSystemResource(String path) {
            this.path = path;
            this.file = Paths.toFile(FileSystemResourceStore.this.baseDirectory, path);
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        public String name() {
            return Paths.name(this.path);
        }

        @Override
        public Resource.Lock lock() {
            return FileSystemResourceStore.this.lockProvider.acquire(this.path);
        }

        @Override
        public void addListener(ResourceListener listener) {
            FileSystemResourceStore.this.addListener(this.file, this.path, listener);
        }

        @Override
        public void removeListener(ResourceListener listener) {
            FileSystemResourceStore.this.removeListener(this.file, this.path, listener);
        }

        @Override
        public InputStream in() {
            File actualFile = this.file();
            if (!actualFile.exists()) {
                throw new IllegalStateException("File not found " + actualFile);
            }
            final Resource.Lock lock = this.lock();
            try {
                return new FileInputStream(this.file){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        lock.release();
                    }
                };
            }
            catch (FileNotFoundException e) {
                lock.release();
                throw new IllegalStateException("File not found " + actualFile, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream out() {
            final File actualFile = this.file();
            if (!actualFile.exists()) {
                throw new IllegalStateException("Cannot access " + actualFile);
            }
            try {
                File temp;
                FileSystemResource fileSystemResource = this;
                synchronized (fileSystemResource) {
                    UUID uuid;
                    File tryTemp;
                    do {
                        uuid = UUID.randomUUID();
                    } while ((tryTemp = new File(actualFile.getParentFile(), String.format("%s.%s.tmp", actualFile.getName(), uuid))).exists());
                    temp = tryTemp;
                }
                return new OutputStream(){
                    FileOutputStream delegate;
                    {
                        this.delegate = new FileOutputStream(temp);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void close() throws IOException {
                        this.delegate.close();
                        if (temp.exists()) {
                            Resource.Lock lock = FileSystemResource.this.lock();
                            try {
                                Files.move(temp, actualFile);
                            }
                            finally {
                                lock.release();
                            }
                        }
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        this.delegate.write(b, off, len);
                    }

                    @Override
                    public void flush() throws IOException {
                        this.delegate.flush();
                    }

                    @Override
                    public void write(byte[] b) throws IOException {
                        this.delegate.write(b);
                    }

                    @Override
                    public void write(int b) throws IOException {
                        this.delegate.write(b);
                    }
                };
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot access " + actualFile, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File file() {
            block11: {
                if (!this.file.exists()) {
                    try {
                        boolean created;
                        File parent = this.file.getParentFile();
                        if (!parent.exists() && !(created = parent.mkdirs())) {
                            throw new IllegalStateException("Unable to create " + parent.getAbsolutePath());
                        }
                        if (parent.isDirectory()) {
                            boolean created2;
                            Resource.Lock lock = this.lock();
                            try {
                                created2 = this.file.createNewFile();
                            }
                            finally {
                                lock.release();
                            }
                            if (!created2) {
                                throw new FileNotFoundException("Unable to create " + this.file.getAbsolutePath());
                            }
                            break block11;
                        }
                        throw new FileNotFoundException("Unable to create" + this.file.getName() + " - not a directory " + parent.getAbsolutePath());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot create " + this.path, e);
                    }
                }
            }
            if (this.file.isDirectory()) {
                throw new IllegalStateException("Directory (not a file) at " + this.path);
            }
            return this.file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File dir() {
            block11: {
                if (!this.file.exists()) {
                    try {
                        boolean created;
                        File parent = this.file.getParentFile();
                        if (!parent.exists() && !(created = parent.mkdirs())) {
                            throw new IllegalStateException("Unable to create " + parent.getAbsolutePath());
                        }
                        if (parent.isDirectory()) {
                            boolean created2;
                            Resource.Lock lock = this.lock();
                            try {
                                created2 = this.file.mkdir();
                            }
                            finally {
                                lock.release();
                            }
                            if (!created2) {
                                throw new FileNotFoundException("Unable to create " + this.file.getAbsolutePath());
                            }
                            break block11;
                        }
                        throw new FileNotFoundException("Unable to create" + this.file.getName() + " - not a directory " + parent.getAbsolutePath());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot create " + this.path, e);
                    }
                }
            }
            if (this.file.isFile()) {
                throw new IllegalStateException("File (not a directory) at " + this.path);
            }
            return this.file;
        }

        @Override
        public long lastmodified() {
            return this.file.lastModified();
        }

        @Override
        public List<Resource> list() {
            if (!this.file.exists()) {
                return Collections.emptyList();
            }
            if (this.file.isFile()) {
                return Collections.emptyList();
            }
            String[] array = this.file.list();
            if (array == null) {
                return Collections.emptyList();
            }
            ArrayList<Resource> list = new ArrayList<Resource>(array.length);
            for (String filename : array) {
                Resource resource = FileSystemResourceStore.this.get(Paths.path(this.path, filename));
                list.add(resource);
            }
            return list;
        }

        @Override
        public Resource parent() {
            int split = this.path.lastIndexOf(47);
            if (split == -1) {
                return FileSystemResourceStore.this.get("");
            }
            return FileSystemResourceStore.this.get(this.path.substring(0, split));
        }

        @Override
        public Resource get(String resourcePath) {
            if (resourcePath == null) {
                throw new NullPointerException("Resource path required");
            }
            if ("".equals(resourcePath)) {
                return this;
            }
            return FileSystemResourceStore.this.get(Paths.path(this.path, resourcePath));
        }

        @Override
        public Resource.Type getType() {
            if (!this.file.exists()) {
                return Resource.Type.UNDEFINED;
            }
            if (this.file.isDirectory()) {
                return Resource.Type.DIRECTORY;
            }
            if (this.file.isFile()) {
                return Resource.Type.RESOURCE;
            }
            throw new IllegalStateException("Path does not represent a configuration resource: " + this.path);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileSystemResource other = (FileSystemResource)obj;
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete() {
            Resource.Lock lock = this.lock();
            try {
                boolean bl = Files.delete(this.file);
                return bl;
            }
            finally {
                lock.release();
            }
        }

        @Override
        public boolean renameTo(Resource dest) {
            if (dest instanceof FileSystemResource) {
                return this.file.renameTo(((FileSystemResource)dest).file);
            }
            if (dest instanceof Files.ResourceAdaptor) {
                return this.file.renameTo(((Files.ResourceAdaptor)dest).file);
            }
            return Resources.renameByCopy(this, dest);
        }
    }
}

