/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.platform.resource.Resources;
import org.geotools.util.logging.Logging;
import org.springframework.core.io.DefaultResourceLoader;

public class GeoServerResourceLoader
extends DefaultResourceLoader
implements ResourceStore {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");
    ResourceStore resources;
    File baseDirectory;

    public GeoServerResourceLoader() {
        this.baseDirectory = null;
        this.resources = ResourceStore.EMPTY;
    }

    public GeoServerResourceLoader(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        this.resources = new FileSystemResourceStore(baseDirectory);
    }

    public GeoServerResourceLoader(ResourceStore resourceStore) {
        this.baseDirectory = resourceStore.get("").dir();
        this.resources = resourceStore;
    }

    public void addSearchLocation(File searchLocation) {
    }

    public void setSearchLocations(Set<File> searchLocations) {
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        this.resources = new FileSystemResourceStore(baseDirectory);
    }

    @Override
    public Resource get(String path) {
        return this.resources.get(path);
    }

    @Override
    public boolean move(String path, String target) {
        return this.resources.move(path, target);
    }

    @Override
    public boolean remove(String path) {
        return this.resources.remove(path);
    }

    public File url(String url) {
        return Files.url(this.baseDirectory, url);
    }

    public File find(String location) throws IOException {
        Resource resource = this.get(Paths.convert(location));
        return Resources.find(resource);
    }

    public File find(File parentFile, String location) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Looking up resource " + location + " with parent " + (parentFile != null ? parentFile.getPath() : "null"));
        }
        Resource resource = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return Resources.find(resource);
    }

    public File find(String ... location) throws IOException {
        Resource resource = this.get(Paths.path(location));
        return Resources.find(resource);
    }

    public File find(File parentFile, String ... location) throws IOException {
        Resource resource = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return Resources.find(resource);
    }

    String concat(String ... location) {
        StringBuffer loc = new StringBuffer();
        for (int i = 0; i < location.length; ++i) {
            loc.append(location[i]).append(File.separator);
        }
        loc.setLength(loc.length() - 1);
        return loc.toString();
    }

    public File findOrCreateDirectory(String ... location) throws IOException {
        Resource directory = this.get(Paths.path(location));
        return directory.dir();
    }

    public File findOrCreateDirectory(File parentFile, String ... location) throws IOException {
        Resource directory = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return directory.dir();
    }

    public File findOrCreateDirectory(String location) throws IOException {
        Resource directory = this.get(Paths.convert(location));
        return directory.dir();
    }

    public File findOrCreateDirectory(File parentFile, String location) throws IOException {
        Resource directory = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return directory.dir();
    }

    public File createDirectory(String ... location) throws IOException {
        Resource directory = this.get(Paths.path(location));
        return Resources.createNewDirectory(directory);
    }

    public File createDirectory(File parentFile, String ... location) throws IOException {
        Resource directory = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return Resources.createNewDirectory(directory);
    }

    public File createDirectory(String location) throws IOException {
        Resource directory = this.get(Paths.convert(location));
        return Resources.createNewDirectory(directory);
    }

    public File createDirectory(File parentFile, String location) throws IOException {
        Resource directory = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return Resources.createNewDirectory(directory);
    }

    public File createFile(String ... location) throws IOException {
        Resource resource = this.get(Paths.path(location));
        return Resources.createNewFile(resource);
    }

    public File createFile(String location) throws IOException {
        Resource resource = this.get(Paths.convert(location));
        return Resources.createNewFile(resource);
    }

    public File createFile(File parentFile, String ... location) throws IOException {
        Resource resource = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return Resources.createNewFile(resource);
    }

    public File createFile(File parentFile, String location) throws IOException {
        Resource resource = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return Resources.createNewFile(resource);
    }

    public void copyFromClassPath(String classpathResource, String location) throws IOException {
        Resource resource = this.get(Paths.convert(location));
        this.copyFromClassPath(classpathResource, resource.file());
    }

    public void copyFromClassPath(String classpathResource, File target) throws IOException {
        this.copyFromClassPath(classpathResource, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromClassPath(String classpathResource, File target, Class<?> scope) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        byte[] buffer = new byte[4096];
        try {
            if (scope == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathResource);
                if (is == null) {
                    throw new IOException("Could not load " + classpathResource + " from scope " + Thread.currentThread().getContextClassLoader().toString() + ".");
                }
            } else {
                is = scope.getResourceAsStream(classpathResource);
                if (is == null) {
                    throw new IOException("Could not load " + classpathResource + " from scope " + scope.toString() + ".");
                }
            }
            try {
                int read;
                os = new FileOutputStream(target);
                while ((read = is.read(buffer)) > 0) {
                    os.write(buffer, 0, read);
                }
            }
            catch (FileNotFoundException targetException) {
                throw new IOException("Can't write to file " + target.getAbsolutePath() + ". Check write permissions on target folder for user " + System.getProperty("user.name"));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error trying to copy logging configuration file", e);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static String lookupGeoServerDataDirectory(ServletContext servContext) {
        String[] typeStrs = new String[]{"Java environment variable ", "Servlet context parameter ", "System environment variable "};
        String[] varStrs = new String[]{"GEOSERVER_DATA_DIR", "GEOSERVER_DATA_ROOT"};
        String dataDirStr = null;
        String msgPrefix = null;
        for (int i = 0; i < varStrs.length && dataDirStr == null; ++i) {
            for (int j = 0; j < typeStrs.length && dataDirStr == null; ++j) {
                String value = null;
                String varStr = varStrs[i];
                String typeStr = typeStrs[j];
                switch (j) {
                    case 0: {
                        value = System.getProperty(varStr);
                        break;
                    }
                    case 1: {
                        value = servContext.getInitParameter(varStr);
                        break;
                    }
                    case 2: {
                        value = System.getenv(varStr);
                    }
                }
                if (value == null || value.equalsIgnoreCase("")) {
                    LOGGER.finer("Found " + typeStr + varStr + " to be unset");
                    continue;
                }
                File fh = new File(value);
                msgPrefix = "Found " + typeStr + varStr + " set to " + value;
                if (!fh.exists()) {
                    LOGGER.warning(msgPrefix + " , but this path does not exist");
                    continue;
                }
                if (!fh.isDirectory()) {
                    LOGGER.warning(msgPrefix + " , which is not a directory");
                    continue;
                }
                if (!fh.canWrite()) {
                    LOGGER.warning(msgPrefix + " , which is not writeable");
                    continue;
                }
                dataDirStr = value;
            }
        }
        if (dataDirStr == null) {
            dataDirStr = servContext.getRealPath("/data");
            LOGGER.info("Falling back to embedded data directory: " + dataDirStr);
        }
        return dataDirStr;
    }

    static {
        LOGGER.setLevel(Level.FINER);
    }
}

