/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Name;
import javax.naming.directory.DirContext;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.impl.AbstractGeoServerSecurityService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.ldap.BindingLdapTemplate;
import org.geoserver.security.ldap.LDAPRoleServiceConfig;
import org.geoserver.security.ldap.LDAPUtils;
import org.geotools.util.logging.Logging;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextCallback;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapEntryIdentification;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;

public class LDAPRoleService
extends AbstractGeoServerSecurityService
implements GeoServerRoleService {
    private static final SortedSet<GeoServerRole> emptySet = Collections.unmodifiableSortedSet(new TreeSet());
    private static final SortedSet<String> emptyStringSet = Collections.unmodifiableSortedSet(new TreeSet());
    private static final Map<String, String> emptyMap = Collections.emptyMap();
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.ldap");
    protected Set<RoleLoadedListener> listeners = Collections.synchronizedSet(new HashSet());
    LdapContextSource ldapContext;
    SpringSecurityLdapTemplate template;
    String groupSearchBase;
    String user;
    String password;
    String groupSearchFilter = "member={0}";
    String groupMembershipAttribute = "member";
    Pattern userMembershipPattern = Pattern.compile("^(.*)$");
    String userNameAttribute = "uid";
    Pattern userNamePattern = Pattern.compile("^(.*)$");
    String userFilter = null;
    boolean lookupUserForDn = false;
    String allGroupsSearchFilter = "cn=*";
    private String groupRoleAttribute = "cn";
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;
    private String adminGroup;
    private String groupAdminGroup;
    Pattern lookForMembershipAttribute = Pattern.compile("^\\(*([a-z]+)=(.*?)\\{([01])\\}(.*?)\\)*$", 2);

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        Matcher m;
        super.initializeFromConfig(config);
        LDAPRoleServiceConfig ldapConfig = (LDAPRoleServiceConfig)config;
        this.ldapContext = LDAPUtils.createLdapContext(ldapConfig);
        if (ldapConfig.isBindBeforeGroupSearch().booleanValue()) {
            this.user = ldapConfig.getUser();
            this.password = ldapConfig.getPassword();
            this.template = new BindingLdapTemplate((ContextSource)this.ldapContext);
        } else {
            this.template = new SpringSecurityLdapTemplate((ContextSource)this.ldapContext);
        }
        this.groupSearchBase = ldapConfig.getGroupSearchBase();
        if (this.isNotEmpty(ldapConfig.getGroupSearchFilter())) {
            this.groupSearchFilter = ldapConfig.getGroupSearchFilter();
            m = this.lookForMembershipAttribute.matcher(this.groupSearchFilter);
            if (m.matches()) {
                this.groupMembershipAttribute = m.group(1);
                this.lookupUserForDn = m.group(3).equals("1");
                this.userMembershipPattern = Pattern.compile("^" + Pattern.quote(m.group(2)) + "(.*)" + Pattern.quote(m.group(4)) + "$");
            }
        }
        if (this.isNotEmpty(ldapConfig.getAllGroupsSearchFilter())) {
            this.allGroupsSearchFilter = ldapConfig.getAllGroupsSearchFilter();
        }
        if (this.isNotEmpty(ldapConfig.getAdminGroup())) {
            this.adminGroup = ldapConfig.getAdminGroup();
        }
        if (this.isNotEmpty(ldapConfig.getGroupAdminGroup())) {
            this.groupAdminGroup = ldapConfig.getGroupAdminGroup();
        }
        if (this.isNotEmpty(ldapConfig.getUserFilter())) {
            this.userFilter = ldapConfig.getUserFilter();
            m = this.lookForMembershipAttribute.matcher(this.userFilter);
            if (m.matches()) {
                this.userNameAttribute = m.group(1);
                this.userNamePattern = Pattern.compile("^" + Pattern.quote(m.group(2)) + "(.*)" + Pattern.quote(m.group(4)) + "$");
            }
        }
    }

    private boolean isNotEmpty(String property) {
        return property != null && !property.isEmpty();
    }

    public boolean canCreateStore() {
        return false;
    }

    public GeoServerRoleStore createStore() throws IOException {
        return null;
    }

    public void registerRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.remove(listener);
    }

    public SortedSet<String> getGroupNamesForRole(GeoServerRole role) throws IOException {
        return emptyStringSet;
    }

    public SortedSet<String> getUserNamesForRole(final GeoServerRole role) throws IOException {
        final TreeSet users = new TreeSet();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPRoleService.this.fillUsersForRole(ctx, users, role);
            }
        });
        return Collections.unmodifiableSortedSet(users);
    }

    public SortedSet<GeoServerRole> getRolesForUser(final String username) throws IOException {
        final TreeSet roles = new TreeSet();
        final HashSet<String> userDn = new HashSet<String>();
        userDn.add(username);
        if (this.lookupUserForDn && this.isNotEmpty(this.userFilter)) {
            this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

                public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                    try {
                        String dn = LDAPUtils.getLdapTemplateInContext(ctx, LDAPRoleService.this.template).searchForSingleEntry("", LDAPRoleService.this.userFilter, (Object[])new String[]{username}).getDn().toString();
                        userDn.clear();
                        userDn.add(dn);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPRoleService.this.fillRolesForUser(ctx, username, (String)userDn.iterator().next(), roles);
            }
        });
        return Collections.unmodifiableSortedSet(roles);
    }

    public SortedSet<GeoServerRole> getRolesForGroup(String groupname) throws IOException {
        return emptySet;
    }

    public SortedSet<GeoServerRole> getRoles() throws IOException {
        final TreeSet roles = new TreeSet();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPRoleService.this.fillAllRoles(ctx, roles);
            }
        });
        return Collections.unmodifiableSortedSet(roles);
    }

    private void authenticateIfNeeded(AuthenticatedLdapEntryContextCallback callback) {
        if (this.user != null && this.password != null) {
            this.template.authenticate((Name)DistinguishedName.EMPTY_PATH, this.user, this.password, callback);
        } else {
            callback.executeWithContext(null, null);
        }
    }

    private void fillAllRoles(DirContext ctx, SortedSet<GeoServerRole> roles) {
        Set roleNames = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleAttributeValues(this.groupSearchBase, this.allGroupsSearchFilter, (Object[])new String[0], this.groupRoleAttribute);
        this.addRolesToSet(roles, roleNames);
    }

    private void fillUsersForRole(DirContext ctx, SortedSet<String> users, GeoServerRole role) {
        Object[] usernames;
        DirContextOperations roleObj = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleEntry(this.groupSearchBase, "cn={0}", (Object[])new String[]{role.toString()});
        if (roleObj != null && (usernames = roleObj.getObjectAttributes(this.groupMembershipAttribute)) != null) {
            for (Object username : usernames) {
                String user = username.toString();
                Matcher m = this.userMembershipPattern.matcher(user);
                if (m.matches()) {
                    user = m.group(1);
                }
                if (this.lookupUserForDn) {
                    user = this.getUserNameFromMembership(user);
                }
                users.add(user);
            }
        }
    }

    private String getUserNameFromMembership(final String user) {
        final HashSet<String> userName = new HashSet<String>();
        userName.add(user);
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                DirContextOperations obj = (DirContextOperations)LDAPUtils.getLdapTemplateInContext(ctx, LDAPRoleService.this.template).lookup(user);
                String name = obj.getObjectAttribute(LDAPRoleService.this.userNameAttribute).toString();
                Matcher m = LDAPRoleService.this.userNamePattern.matcher(name);
                if (m.matches()) {
                    name = m.group(1);
                }
                userName.clear();
                userName.add(name);
            }
        });
        return (String)userName.iterator().next();
    }

    private void addRolesToSet(SortedSet<GeoServerRole> roles, Set<String> roleNames) {
        for (String roleName : roleNames) {
            try {
                roles.add(this.createRoleObject(roleName));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error adding a new role from LDAP", e);
            }
        }
    }

    private void fillRolesForUser(DirContext ctx, String username, String userDn, SortedSet<GeoServerRole> roles) {
        Set roleNames = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleAttributeValues(this.groupSearchBase, this.groupSearchFilter, (Object[])new String[]{username, userDn}, this.groupRoleAttribute);
        this.addRolesToSet(roles, roleNames);
    }

    public Map<String, String> getParentMappings() throws IOException {
        return emptyMap;
    }

    public GeoServerRole createRoleObject(String role) throws IOException {
        return new GeoServerRole(this.rolePrefix + (this.convertToUpperCase ? role.toUpperCase() : role));
    }

    public GeoServerRole getParentRole(GeoServerRole role) throws IOException {
        return null;
    }

    public GeoServerRole getRoleByName(String role) throws IOException {
        if (role.startsWith("ROLE_")) {
            role = role.substring(5);
        }
        final String roleName = role;
        final TreeSet roles = new TreeSet();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                roles.addAll(LDAPUtils.getLdapTemplateInContext(ctx, LDAPRoleService.this.template).searchForSingleAttributeValues(LDAPRoleService.this.groupSearchBase, "cn=" + roleName, (Object[])new String[]{roleName}, LDAPRoleService.this.groupRoleAttribute));
            }
        });
        if (roles.size() == 1) {
            return this.createRoleObject(role);
        }
        return null;
    }

    public void load() throws IOException {
    }

    public Properties personalizeRoleParams(String roleName, Properties roleParams, String userName, Properties userProps) throws IOException {
        return null;
    }

    public GeoServerRole getAdminRole() {
        if (this.adminGroup == null) {
            return null;
        }
        try {
            return this.getRoleByName(this.adminGroup);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GeoServerRole getGroupAdminRole() {
        if (this.groupAdminGroup == null) {
            return null;
        }
        try {
            return this.getRoleByName(this.groupAdminGroup);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getRoleCount() throws IOException {
        return this.getRoles().size();
    }
}

