/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.text.MessageFormat;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.AuthenticationException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.OperationNotSupportedException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.ppolicy.PasswordPolicyControlExtractor;
import org.springframework.security.ldap.ppolicy.PasswordPolicyResponseControl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GeoserverLdapBindAuthenticator
extends BindAuthenticator {
    private static final Log logger = LogFactory.getLog(GeoserverLdapBindAuthenticator.class);
    private String userFilter = "";
    private String userFormat = "";

    public GeoserverLdapBindAuthenticator(BaseLdapPathContextSource contextSource) {
        super(contextSource);
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public DirContextOperations authenticate(Authentication authentication) {
        if (this.userFilter == null || this.userFilter.equals("")) {
            return super.authenticate(authentication);
        }
        return this.authenticateUsingFilter(authentication);
    }

    /*
     * Loose catch block
     */
    protected DirContextOperations authenticateUsingFilter(Authentication authentication) {
        DirContext ctx;
        DirContextOperations user;
        block10: {
            String username;
            user = null;
            Assert.isInstanceOf(UsernamePasswordAuthenticationToken.class, (Object)authentication, (String)"Can only process UsernamePasswordAuthenticationToken objects");
            String originalUser = username = authentication.getName();
            String password = (String)authentication.getCredentials();
            if (this.userFormat != null && !this.userFormat.equals("")) {
                username = MessageFormat.format(this.userFormat, username);
            }
            if (!StringUtils.hasLength((String)password)) {
                logger.debug((Object)("Rejecting empty password for user " + username));
                throw new BadCredentialsException(this.messages.getMessage("BindAuthenticator.emptyPassword", "Empty Password"));
            }
            ctx = null;
            String userDnStr = "";
            try {
                ctx = this.getContextSource().getContext(username, password);
                PasswordPolicyResponseControl ppolicy = PasswordPolicyControlExtractor.extractControl((DirContext)ctx);
                logger.debug((Object)"Retrieving user object using filter...");
                SearchControls searchCtls = new SearchControls();
                searchCtls.setSearchScope(2);
                user = SpringSecurityLdapTemplate.searchForSingleEntryInternal((DirContext)ctx, (SearchControls)searchCtls, (String)"", (String)this.userFilter, (Object[])new Object[]{username, originalUser});
                userDnStr = user.getDn().toString();
                if (ppolicy == null) break block10;
                user.setAttributeValue(ppolicy.getID(), (Object)ppolicy);
            }
            catch (NamingException e) {
                if (!(e instanceof AuthenticationException) && !(e instanceof OperationNotSupportedException)) {
                    throw e;
                }
                this.handleBindException(userDnStr, username, e);
                LdapUtils.closeContext((DirContext)ctx);
            }
            catch (javax.naming.NamingException e2) {
                throw LdapUtils.convertLdapException((javax.naming.NamingException)e2);
                {
                    catch (Throwable throwable) {
                        LdapUtils.closeContext(ctx);
                        throw throwable;
                    }
                }
            }
        }
        LdapUtils.closeContext((DirContext)ctx);
        if (user == null) {
            throw new BadCredentialsException(this.messages.getMessage("BindAuthenticator.badCredentials", "Bad credentials"));
        }
        return user;
    }

    public void setUserFormat(String userFormat) {
        this.userFormat = userFormat;
    }
}

