/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.Name;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geoserver.security.ldap.BindingLdapTemplate;
import org.geoserver.security.ldap.LDAPUtils;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextCallback;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapEntryIdentification;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.util.Assert;

public class BindingLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private static final Log logger = LogFactory.getLog(BindingLdapAuthoritiesPopulator.class);
    private GrantedAuthority defaultRole;
    private final SpringSecurityLdapTemplate ldapTemplate;
    private final SearchControls searchControls = new SearchControls();
    private String groupRoleAttribute = "cn";
    private String groupSearchBase;
    private String groupSearchFilter = "(member={0})";
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;

    public BindingLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        Assert.notNull((Object)contextSource, (String)"contextSource must not be null");
        this.ldapTemplate = new BindingLdapTemplate(contextSource);
        this.ldapTemplate.setSearchControls(this.searchControls);
        this.groupSearchBase = groupSearchBase;
        if (groupSearchBase == null) {
            logger.info((Object)"groupSearchBase is null. No group search will be performed.");
        } else if (groupSearchBase.length() == 0) {
            logger.info((Object)"groupSearchBase is empty. Searches will be performed from the context source base");
        }
    }

    protected Set<GrantedAuthority> getAdditionalRoles(DirContext ctx, DirContextOperations user, String username) {
        return null;
    }

    public final Collection<GrantedAuthority> getGrantedAuthorities(DirContextOperations user, String username) {
        return this.getGrantedAuthorities(user, username, null);
    }

    public final Collection<GrantedAuthority> getGrantedAuthorities(final DirContextOperations user, final String username, String password) {
        final String userDn = user.getNameInNamespace();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting authorities for user " + userDn));
        }
        final ArrayList<GrantedAuthority> result = new ArrayList<GrantedAuthority>();
        if (password != null) {
            this.ldapTemplate.authenticate((Name)DistinguishedName.EMPTY_PATH, userDn, password, new AuthenticatedLdapEntryContextCallback(){

                public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                    BindingLdapAuthoritiesPopulator.this.getAllRoles(user, userDn, result, username, ctx);
                }
            });
        } else {
            this.getAllRoles(user, userDn, result, username, null);
        }
        return result;
    }

    public Set<GrantedAuthority> getGroupMembershipRoles(DirContext ctx, String userDn, String username) {
        if (this.getGroupSearchBase() == null) {
            return new HashSet<GrantedAuthority>();
        }
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for roles for user '" + username + "', DN = " + "'" + userDn + "', with filter " + this.groupSearchFilter + " in search base '" + this.getGroupSearchBase() + "'"));
        }
        SpringSecurityLdapTemplate authTemplate = LDAPUtils.getLdapTemplateInContext(ctx, this.ldapTemplate);
        Set userRoles = authTemplate.searchForSingleAttributeValues(this.getGroupSearchBase(), this.groupSearchFilter, (Object[])new String[]{userDn, username}, this.groupRoleAttribute);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Roles from search: " + userRoles));
        }
        for (String role : userRoles) {
            if (this.convertToUpperCase) {
                role = role.toUpperCase();
            }
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(this.rolePrefix + role));
        }
        return authorities;
    }

    protected ContextSource getContextSource() {
        return this.ldapTemplate.getContextSource();
    }

    protected String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    @Deprecated
    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    @Deprecated
    public void setDefaultRole(String defaultRole) {
        Assert.notNull((Object)defaultRole, (String)"The defaultRole property cannot be set to null");
        this.defaultRole = new SimpleGrantedAuthority(defaultRole);
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        Assert.notNull((Object)groupRoleAttribute, (String)"groupRoleAttribute must not be null");
        this.groupRoleAttribute = groupRoleAttribute;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        Assert.notNull((Object)groupSearchFilter, (String)"groupSearchFilter must not be null");
        this.groupSearchFilter = groupSearchFilter;
    }

    @Deprecated
    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix must not be null");
        this.rolePrefix = rolePrefix;
    }

    public void setSearchSubtree(boolean searchSubtree) {
        int searchScope = searchSubtree ? 2 : 1;
        this.searchControls.setSearchScope(searchScope);
    }

    public void setIgnorePartialResultException(boolean ignore) {
        this.ldapTemplate.setIgnorePartialResultException(ignore);
    }

    private void getAllRoles(DirContextOperations user, String userDn, List<GrantedAuthority> result, String userName, DirContext ctx) {
        Set<GrantedAuthority> roles = this.getGroupMembershipRoles(ctx, userDn, userName);
        Set<GrantedAuthority> extraRoles = this.getAdditionalRoles(ctx, user, userName);
        if (extraRoles != null) {
            roles.addAll(extraRoles);
        }
        if (this.defaultRole != null) {
            roles.add(this.defaultRole);
        }
        result.addAll(roles);
    }
}

