/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.RoleCalculator;
import org.geoserver.security.jdbc.config.JDBCConnectAuthProviderConfig;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class JDBCConnectAuthProvider
extends GeoServerAuthenticationProvider {
    protected String connectUrl;
    protected String driverClassName;
    protected String userGroupServiceName;

    public boolean supports(Class<? extends Object> authentication, HttpServletRequest request) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication authenticate(Authentication authentication, HttpServletRequest request) throws AuthenticationException {
        UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)authentication;
        if (token.getPrincipal() == null || token.getPrincipal().toString().isEmpty()) {
            return null;
        }
        String user = token.getPrincipal().toString();
        String password = token.getCredentials() == null ? "" : token.getCredentials().toString();
        UserDetails details = null;
        if (this.userGroupServiceName != null) {
            try {
                GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService(this.userGroupServiceName);
                details = service.loadUserByUsername(user);
                if (!details.isEnabled()) {
                    this.log((AuthenticationException)new DisabledException("User " + user + " is disabled"));
                    return null;
                }
            }
            catch (IOException ex) {
                this.log((AuthenticationException)new AuthenticationServiceException(ex.getLocalizedMessage(), (Throwable)ex));
                return null;
            }
            catch (UsernameNotFoundException ex) {
                this.log((AuthenticationException)((Object)ex));
            }
            catch (AuthenticationException ex) {
                this.log(ex);
                return null;
            }
        }
        Connection con = null;
        try {
            con = DriverManager.getConnection(this.connectUrl, user, password);
        }
        catch (SQLInvalidAuthorizationSpecException ex) {
            this.log((AuthenticationException)new BadCredentialsException("Bad credentials for " + user, (Throwable)ex));
            Authentication authentication2 = null;
            return authentication2;
        }
        catch (SQLException ex) {
            this.log((AuthenticationException)new AuthenticationServiceException("JDBC connect error", (Throwable)ex));
            Authentication authentication3 = null;
            return authentication3;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ex2) {}
            }
        }
        UsernamePasswordAuthenticationToken result = null;
        HashSet<GeoServerRole> roles = new HashSet<GeoServerRole>();
        if (details != null) {
            roles.addAll(details.getAuthorities());
        } else {
            RoleCalculator calc = new RoleCalculator(this.getSecurityManager().getActiveRoleService());
            try {
                roles.addAll(calc.calculateRoles(new GeoServerUser(user)));
            }
            catch (IOException e) {
                throw new AuthenticationServiceException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        roles.add(GeoServerRole.AUTHENTICATED_ROLE);
        result = new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), null, roles);
        result.setDetails(authentication.getDetails());
        return result;
    }

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        JDBCConnectAuthProviderConfig jdbcConfig = (JDBCConnectAuthProviderConfig)config;
        this.userGroupServiceName = jdbcConfig.getUserGroupServiceName();
        this.connectUrl = jdbcConfig.getConnectURL();
        this.driverClassName = jdbcConfig.getDriverClassName();
        try {
            Class.forName(this.driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }
}

