/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import javax.xml.transform.TransformerException;
import net.opengis.wcs11.GetCoverageType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Response;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.response.CoveragesTransformer;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.opengis.coverage.grid.GridCoverage;
import org.vfny.geoserver.wcs.WcsException;

public class WCSGetCoverageStoreResponse
extends Response {
    GeoServer geoServer;
    Catalog catalog;
    CoverageResponseDelegateFinder responseFactory;

    public WCSGetCoverageStoreResponse(GeoServer gs, CoverageResponseDelegateFinder responseFactory) {
        super(GridCoverage[].class);
        this.geoServer = gs;
        this.catalog = gs.getCatalog();
        this.responseFactory = responseFactory;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/xml";
    }

    public boolean canHandle(Operation operation) {
        if (!(operation.getParameters()[0] instanceof GetCoverageType)) {
            return false;
        }
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        return getCoverage.getOutput().isStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        GridCoverage[] coverages = (GridCoverage[])value;
        GetCoverageType request = (GetCoverageType)operation.getParameters()[0];
        String outputFormat = request.getOutput().getFormat();
        CoverageResponseDelegate delegate = this.responseFactory.encoderFor(outputFormat);
        if (delegate == null) {
            throw new WcsException("Could not find encoder for output format " + outputFormat);
        }
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        CoverageInfo coverageInfo = this.catalog.getCoverageByName(request.getIdentifier().getValue());
        File wcsStore = null;
        try {
            GeoServerResourceLoader loader = this.geoServer.getCatalog().getResourceLoader();
            Resource wcs = loader.get("temp/wcs");
            wcsStore = wcs.dir();
        }
        catch (Exception e) {
            throw new WcsException("Could not create the temporary storage directory for WCS");
        }
        File coverageFile = null;
        while ((coverageFile = new File(wcsStore, coverageInfo.getName().replace(':', '_') + "_" + System.nanoTime() + "." + delegate.getFileExtension(outputFormat))).exists()) {
        }
        try (OutputStream os = null;){
            os = new BufferedOutputStream(new FileOutputStream(coverageFile));
            delegate.encode(coverage, outputFormat, Collections.EMPTY_MAP, os);
            os.flush();
        }
        System.out.println(coverageFile);
        String coverageLocation = ResponseUtils.buildURL((String)request.getBaseUrl(), (String)ResponseUtils.appendPath((String[])new String[]{"temp/wcs", coverageFile.getName()}), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
        WCSInfo wcs = (WCSInfo)this.geoServer.getService(WCSInfo.class);
        CoveragesTransformer tx = new CoveragesTransformer(wcs, request, coverageLocation);
        try {
            tx.transform(coverageInfo, output);
        }
        catch (TransformerException e) {
            throw new WcsException("Failure trying to encode Coverages response", (Throwable)e);
        }
    }
}

