/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wcs11.GetCapabilitiesType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.SettingsInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wcs.WCSInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.global.CoverageInfoLabelComparator;
import org.vfny.geoserver.wcs.WcsException;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class WCSCapsTransformer
extends TransformerBase {
    protected static final Logger LOGGER = Logging.getLogger((String)WCSCapsTransformer.class.getPackage().getName());
    protected static final String WCS_URI = "http://www.opengis.net/wcs/1.1.1";
    protected static final String CUR_VERSION = "1.1.1";
    protected static final String XSI_PREFIX = "xsi";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    protected WCSInfo wcs;
    protected Catalog catalog;
    protected final boolean skipMisconfigured;

    public WCSCapsTransformer(GeoServer gs) {
        this.wcs = (WCSInfo)gs.getService(WCSInfo.class);
        this.catalog = gs.getCatalog();
        this.skipMisconfigured = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)gs.getGlobal().getResourceErrorHandling());
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new WCS111CapsTranslator(handler);
    }

    protected class WCS111CapsTranslator
    extends TransformerBase.TranslatorSupport {
        protected GetCapabilitiesType request;

        public WCS111CapsTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            EList sections;
            boolean allSections;
            if (!(o instanceof GetCapabilitiesType)) {
                throw new IllegalArgumentException(new StringBuffer("Not a GetCapabilitiesType: ").append(o).toString());
            }
            this.request = (GetCapabilitiesType)o;
            long updateSequence = WCSCapsTransformer.this.wcs.getGeoServer().getGlobal().getUpdateSequence();
            long requestedUpdateSequence = -1L;
            if (this.request.getUpdateSequence() != null) {
                try {
                    requestedUpdateSequence = Long.parseLong(this.request.getUpdateSequence());
                }
                catch (NumberFormatException e) {
                    throw new WcsException("Invalid update sequence number format, should be an integer", WcsException.WcsExceptionCode.InvalidUpdateSequence, "updateSequence");
                }
                if (requestedUpdateSequence > updateSequence) {
                    throw new WcsException("Invalid update sequence value, it's higher than the current value, " + updateSequence, WcsException.WcsExceptionCode.InvalidUpdateSequence, "updateSequence");
                }
            }
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "version", "version", "", WCSCapsTransformer.CUR_VERSION);
            attributes.addAttribute("", "xmlns:wcs", "xmlns:wcs", "", WCSCapsTransformer.WCS_URI);
            attributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", "http://www.w3.org/1999/xlink");
            attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", "http://www.opengis.net/ogc");
            attributes.addAttribute("", "xmlns:ows", "xmlns:ows", "", "http://www.opengis.net/ows/1.1");
            attributes.addAttribute("", "xmlns:gml", "xmlns:gml", "", "http://www.opengis.net/gml");
            String prefixDef = new StringBuffer("xmlns:").append(WCSCapsTransformer.XSI_PREFIX).toString();
            attributes.addAttribute("", prefixDef, prefixDef, "", WCSCapsTransformer.XSI_URI);
            String locationAtt = new StringBuffer(WCSCapsTransformer.XSI_PREFIX).append(":schemaLocation").toString();
            String locationDef = "http://www.opengis.net/wcs/1.1.1 " + ResponseUtils.buildSchemaURL((String)this.request.getBaseUrl(), (String)"wcs/1.1.1/wcsGetCapabilities.xsd");
            attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
            attributes.addAttribute("", "updateSequence", "updateSequence", "", String.valueOf(updateSequence));
            this.start("wcs:Capabilities", attributes);
            if (this.request.getSections() == null) {
                allSections = true;
                sections = Collections.emptyList();
            } else {
                sections = this.request.getSections().getSection();
                allSections = sections.contains("All");
            }
            HashSet<String> knownSections = new HashSet<String>(Arrays.asList("ServiceIdentification", "ServiceProvider", "OperationsMetadata", "Contents", "All"));
            for (String section : sections) {
                if (knownSections.contains(section)) continue;
                throw new WcsException("Unknown section " + section, WcsException.WcsExceptionCode.InvalidParameterValue, "Sections");
            }
            if (requestedUpdateSequence < updateSequence) {
                if (allSections || sections.contains("ServiceIdentification")) {
                    this.handleServiceIdentification();
                }
                if (allSections || sections.contains("ServiceProvider")) {
                    this.handleServiceProvider();
                }
                if (allSections || sections.contains("OperationsMetadata")) {
                    this.handleOperationsMetadata();
                }
                if (allSections || sections.contains("Contents")) {
                    this.handleContents();
                }
            }
            this.end("wcs:Capabilities");
        }

        protected void handleServiceIdentification() {
            this.start("ows:ServiceIdentification");
            this.element("ows:Title", WCSCapsTransformer.this.wcs.getTitle());
            this.element("ows:Abstract", WCSCapsTransformer.this.wcs.getAbstract());
            this.handleKeywords(WCSCapsTransformer.this.wcs.getKeywords());
            this.element("ows:ServiceType", "WCS");
            this.element("ows:ServiceTypeVersion", "1.1.0");
            this.element("ows:ServiceTypeVersion", WCSCapsTransformer.CUR_VERSION);
            String fees = WCSCapsTransformer.this.wcs.getFees();
            if (fees == null || "".equals(fees)) {
                fees = "NONE";
            }
            this.element("ows:Fees", fees);
            String accessConstraints = WCSCapsTransformer.this.wcs.getAccessConstraints();
            if (accessConstraints == null || "".equals(accessConstraints)) {
                accessConstraints = "NONE";
            }
            this.element("ows:AccessConstraints", accessConstraints);
            this.end("ows:ServiceIdentification");
        }

        protected void handleServiceProvider() {
            this.start("ows:ServiceProvider");
            SettingsInfo settings = WCSCapsTransformer.this.wcs.getGeoServer().getSettings();
            this.element("ows:ProviderName", settings.getContact().getContactOrganization());
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", settings.getOnlineResource() != null ? settings.getOnlineResource() : "");
            this.element("ows:ProviderSite", null, attributes);
            this.handleContact();
            this.end("ows:ServiceProvider");
        }

        protected void handleOperationsMetadata() {
            this.start("ows:OperationsMetadata");
            this.handleOperation("GetCapabilities", null);
            this.handleOperation("DescribeCoverage", null);
            this.handleOperation("GetCoverage", (Map<String, List<String>>)new HashMap<String, List<String>>(){
                {
                    this.put("store", Arrays.asList("True", "False"));
                }
            });
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(null, "name", "name", null, "PostEncoding");
            this.start("ows:Constraint", attributes);
            this.start("ows:AllowedValues");
            this.element("ows:Value", "XML");
            this.end("ows:AllowedValues");
            this.end("ows:Constraint");
            this.end("ows:OperationsMetadata");
        }

        protected void handleOperation(String capabilityName, Map<String, List<String>> parameters) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(null, "name", "name", null, capabilityName);
            this.start("ows:Operation", attributes);
            String url = ResponseUtils.appendQueryString((String)ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wcs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE), (String)"");
            this.start("ows:DCP");
            this.start("ows:HTTP");
            attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
            this.element("ows:Get", null, attributes);
            this.end("ows:HTTP");
            this.end("ows:DCP");
            attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
            this.start("ows:DCP");
            this.start("ows:HTTP");
            this.element("ows:Post", null, attributes);
            this.end("ows:HTTP");
            this.end("ows:DCP");
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, List<String>> param : parameters.entrySet()) {
                    attributes = new AttributesImpl();
                    attributes.addAttribute("", "name", "name", "", param.getKey());
                    this.start("ows:Parameter", attributes);
                    this.start("ows:AllowedValues");
                    for (String value : param.getValue()) {
                        this.element("ows:Value", value);
                    }
                    this.end("ows:AllowedValues");
                    this.end("ows:Parameter");
                }
            }
            this.end("ows:Operation");
        }

        protected void handleKeywords(List kwords) {
            if (kwords != null && kwords.size() > 0) {
                this.start("ows:Keywords");
                if (kwords != null) {
                    Iterator it = kwords.iterator();
                    while (it.hasNext()) {
                        this.element("ows:Keyword", it.next().toString());
                    }
                }
                this.end("ows:Keywords");
            }
        }

        protected void handleContact() {
            GeoServer gs = WCSCapsTransformer.this.wcs.getGeoServer();
            this.start("ows:ServiceContact");
            ContactInfo contact = gs.getSettings().getContact();
            this.elementIfNotEmpty("ows:IndividualName", contact.getContactPerson());
            this.elementIfNotEmpty("ows:PositionName", contact.getContactPosition());
            this.start("ows:ContactInfo");
            this.start("ows:Phone");
            this.elementIfNotEmpty("ows:Voice", contact.getContactVoice());
            this.elementIfNotEmpty("ows:Facsimile", contact.getContactFacsimile());
            this.end("ows:Phone");
            this.start("ows:Address");
            this.elementIfNotEmpty("ows:DeliveryPoint", contact.getAddress());
            this.elementIfNotEmpty("ows:City", contact.getAddressCity());
            this.elementIfNotEmpty("ows:AdministrativeArea", contact.getAddressState());
            this.elementIfNotEmpty("ows:PostalCode", contact.getAddressPostalCode());
            this.elementIfNotEmpty("ows:Country", contact.getAddressCountry());
            this.elementIfNotEmpty("ows:ElectronicMailAddress", contact.getContactEmail());
            this.end("ows:Address");
            String or = gs.getSettings().getOnlineResource();
            if (or != null && !"".equals(or.trim())) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "xlink:href", "xlink:href", "", or);
                this.start("ows:OnlineResource", attributes);
                this.end("OnlineResource");
            }
            this.end("ows:ContactInfo");
            this.end("ows:ServiceContact");
        }

        protected void handleEnvelope(ReferencedEnvelope envelope) {
            this.start("ows:WGS84BoundingBox");
            this.element("ows:LowerCorner", new StringBuffer(Double.toString(envelope.getLowerCorner().getOrdinate(0))).append(" ").append(envelope.getLowerCorner().getOrdinate(1)).toString());
            this.element("ows:UpperCorner", new StringBuffer(Double.toString(envelope.getUpperCorner().getOrdinate(0))).append(" ").append(envelope.getUpperCorner().getOrdinate(1)).toString());
            this.end("ows:WGS84BoundingBox");
        }

        protected void handleContents() {
            this.start("wcs:Contents");
            ArrayList coverages = new ArrayList(WCSCapsTransformer.this.wcs.getGeoServer().getCatalog().getCoverages());
            Iterator it = coverages.iterator();
            while (it.hasNext()) {
                CoverageInfo cv = (CoverageInfo)it.next();
                if (cv.enabled()) continue;
                it.remove();
            }
            if (this.request.getNamespace() != null) {
                String namespace = this.request.getNamespace();
                Iterator it2 = coverages.iterator();
                while (it2.hasNext()) {
                    CoverageInfo cv = (CoverageInfo)it2.next();
                    if (namespace.equals(cv.getStore().getWorkspace().getName())) continue;
                    it2.remove();
                }
            }
            Collections.sort(coverages, new CoverageInfoLabelComparator());
            for (CoverageInfo cv : coverages) {
                try {
                    this.mark();
                    this.handleCoverageSummary(cv);
                    this.commit();
                }
                catch (Exception e) {
                    if (WCSCapsTransformer.this.skipMisconfigured) {
                        this.reset();
                        LOGGER.log(Level.SEVERE, "Skipping coverage " + cv.getPrefixedName() + " as its capabilities generation failed", e);
                        continue;
                    }
                    throw new RuntimeException("Capabilities document generation failed on coverage " + cv.getPrefixedName(), e);
                }
            }
            this.end("wcs:Contents");
        }

        protected void handleCoverageSummary(CoverageInfo cv) {
            this.start("wcs:CoverageSummary");
            this.elementIfNotEmpty("ows:Title", cv.getTitle());
            this.elementIfNotEmpty("ows:Abstract", cv.getDescription());
            this.handleKeywords(cv.getKeywords());
            this.handleMetadataLinks(cv.getMetadataLinks(), "simple");
            this.handleEnvelope(cv.getLatLonBoundingBox());
            this.element("wcs:Identifier", cv.prefixedName());
            this.end("wcs:CoverageSummary");
        }

        protected void handleMetadataLinks(List<MetadataLinkInfo> links, String linkType) {
            for (MetadataLinkInfo mdl : links) {
                if (mdl == null) continue;
                this.handleMetadataLink(mdl, linkType);
            }
        }

        protected void handleMetadataLink(MetadataLinkInfo mdl, String linkType) {
            AttributesImpl attributes = new AttributesImpl();
            if (mdl.getAbout() != null && mdl.getAbout() != "") {
                attributes.addAttribute("", "about", "about", "", mdl.getAbout());
            }
            if (linkType != null && linkType != "") {
                attributes.addAttribute("", "xlink:type", "xlink:type", "", linkType);
            }
            if (mdl.getContent() != null && mdl.getContent() != "") {
                attributes.addAttribute("", "xlink:href", "xlink:href", "", org.vfny.geoserver.util.ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)mdl, (String)this.request.getBaseUrl()));
                this.element("ows:Metadata", null, attributes);
            }
        }

        protected void elementIfNotEmpty(String elementName, String content) {
            if (content != null && !"".equals(content.trim())) {
                this.element(elementName, content);
            }
        }
    }
}

