/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.List;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.vfny.geoserver.wcs.WcsException;

public class GridOffsetsKvpParser
extends KvpParser {
    public GridOffsetsKvpParser() {
        super("GridOffsets", double[].class);
    }

    public Object parse(String value) throws Exception {
        List values = KvpUtils.readFlat((String)value);
        if (values.size() < 2) {
            throw new WcsException("Invalid grid offset, should have at least two values", WcsException.WcsExceptionCode.InvalidParameterValue, "GridOffsets");
        }
        Double[] offsets = new Double[values.size()];
        for (int i = 0; i < offsets.length; ++i) {
            try {
                offsets[i] = Double.valueOf((String)values.get(i));
                continue;
            }
            catch (NumberFormatException e) {
                throw new WcsException("Invalid offset " + offsets[i], WcsException.WcsExceptionCode.InvalidParameterValue, "GridOffsets");
            }
        }
        return offsets;
    }
}

