/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public class HttpClientBuilder {
    private UsernamePasswordCredentials httpcredentials = null;
    private UsernamePasswordCredentials proxycredentials = null;
    private AuthScope authscope = null;
    private URL proxyUrl = null;
    private Integer backendTimeoutMillis = null;
    private boolean doAuthentication = false;
    private int concurrency;

    public HttpClientBuilder() {
    }

    public HttpClientBuilder(URL url, Integer backendTimeout, String httpUsername, String httpPassword, URL proxyUrl, int concurrency) {
        if (url != null) {
            this.setHttpCredentials(httpUsername, httpPassword, new AuthScope(url.getHost(), url.getPort()));
        } else {
            this.setHttpCredentials(httpUsername, httpPassword, AuthScope.ANY);
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> lst = runtimeMXBean.getInputArguments();
        String proxyHost = null;
        String proxyPort = null;
        for (String arg : lst) {
            if (arg.startsWith("-Dhttp.proxyHost=")) {
                proxyHost = this.extractVMArg(arg);
                continue;
            }
            if (!arg.startsWith("-Dhttp.proxyPort=")) continue;
            proxyPort = this.extractVMArg(arg);
        }
        if (proxyHost != null) {
            try {
                proxyUrl = new URL(proxyHost + (proxyPort != null ? ":" + proxyPort : ""));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        this.setProxy(proxyUrl);
        this.setBackendTimeout(backendTimeout);
        this.concurrency = concurrency;
    }

    private String extractVMArg(String arg) {
        String[] proxyArg = arg.split("=");
        if (proxyArg.length == 2 && proxyArg[1].length() > 0) {
            return proxyArg[1];
        }
        return null;
    }

    public void setHttpCredentials(String username, String password, URL authscopeUrl) {
        AuthScope authscope = new AuthScope(authscopeUrl.getHost(), authscopeUrl.getPort());
        this.setHttpCredentials(username, password, authscope);
    }

    public void setHttpCredentials(String username, String password, AuthScope authscope) {
        if (username != null && authscope != null) {
            this.authscope = authscope;
            this.httpcredentials = new UsernamePasswordCredentials(username, password);
            this.doAuthentication = true;
        } else {
            this.authscope = null;
            this.httpcredentials = null;
            this.doAuthentication = false;
        }
    }

    public void setProxy(URL proxyUrl) {
        this.proxyUrl = proxyUrl;
        if (this.proxyUrl != null && this.proxyUrl.getUserInfo() != null) {
            String[] userinfo = this.proxyUrl.getUserInfo().split(":");
            this.proxycredentials = new UsernamePasswordCredentials(userinfo[0], userinfo[1]);
        }
    }

    public void setBackendTimeout(int backendTimeout) {
        this.backendTimeoutMillis = backendTimeout * 1000;
    }

    public HttpClient buildClient() {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setSoTimeout(this.backendTimeoutMillis.intValue());
        params.setConnectionTimeout(this.backendTimeoutMillis.intValue());
        if (this.concurrency > 0) {
            params.setMaxTotalConnections(this.concurrency);
            params.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, this.concurrency);
        }
        connectionManager.setParams(params);
        HttpClient httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        if (this.authscope != null && this.httpcredentials != null) {
            httpClient.getState().setCredentials(this.authscope, (Credentials)this.httpcredentials);
            httpClient.getParams().setAuthenticationPreemptive(true);
        }
        if (this.proxyUrl != null) {
            httpClient.getHostConfiguration().setProxy(this.proxyUrl.getHost(), this.proxyUrl.getPort());
            if (this.proxycredentials != null) {
                httpClient.getState().setProxyCredentials(new AuthScope(this.proxyUrl.getHost(), this.proxyUrl.getPort()), (Credentials)this.proxycredentials);
            }
        }
        return httpClient;
    }

    public boolean isDoAuthentication() {
        return this.doAuthentication;
    }
}

