/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.geowebcache.util.CompositeIterator;

public class CompositeIterable<T>
implements Iterable<T> {
    private List<Iterable<T>> iterables;

    public CompositeIterable(Iterable<T> ... iterables) {
        this(iterables == null ? Collections.EMPTY_LIST : Arrays.asList(iterables));
    }

    public CompositeIterable(List<Iterable<T>> iteratbles) {
        this.iterables = new ArrayList<Iterable<T>>(iteratbles);
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList iterators = new ArrayList(4);
        for (Iterable<T> iterable : this.iterables) {
            Iterator<T> iterator = iterable.iterator();
            iterators.add(iterator);
        }
        return new CompositeIterator(iterators);
    }
}

