/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.memory.guava;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.blobstore.memory.CacheConfiguration;
import org.geowebcache.storage.blobstore.memory.CacheProvider;
import org.geowebcache.storage.blobstore.memory.CacheStatistics;

public class GuavaCacheProvider
implements CacheProvider {
    private static final Log LOGGER = LogFactory.getLog(GuavaCacheProvider.class);
    public static final String SEPARATOR = "_";
    public static final long BYTES_TO_MB = 0x100000L;
    public static final int CORE_POOL_SIZE = 1;
    private static final String GUAVA_NAME = "Guava Cache";
    public static final List<CacheConfiguration.EvictionPolicy> POLICIES = Collections.unmodifiableList(Arrays.asList(CacheConfiguration.EvictionPolicy.NULL, CacheConfiguration.EvictionPolicy.EXPIRE_AFTER_ACCESS, CacheConfiguration.EvictionPolicy.EXPIRE_AFTER_WRITE));
    private Cache<String, TileObject> cache;
    private LayerMap multimap;
    private AtomicBoolean configured;
    private AtomicLong actualOperations;
    private final Set<String> layers;
    private long maxMemory = 0L;
    private AtomicLong currentSize = new AtomicLong(0L);
    private ScheduledExecutorService scheduledPool;

    public GuavaCacheProvider(CacheConfiguration config) {
        this.layers = Collections.newSetFromMap(new ConcurrentHashMap());
        this.configured = new AtomicBoolean(false);
        this.actualOperations = new AtomicLong(0L);
        this.configure(config);
    }

    private void initCache(CacheConfiguration configuration) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Building new Cache");
        }
        int concurrency = configuration.getConcurrencyLevel();
        this.maxMemory = configuration.getHardMemoryLimit() * 0x100000L;
        long evictionTime = configuration.getEvictionTime();
        CacheConfiguration.EvictionPolicy policy = configuration.getPolicy();
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
        CacheBuilder builder = CacheBuilder.newBuilder();
        Weigher<String, TileObject> weigher = new Weigher<String, TileObject>(){

            public int weigh(String key, TileObject value) {
                GuavaCacheProvider.this.currentSize.addAndGet(value.getBlobSize());
                return value.getBlobSize();
            }
        };
        CacheBuilder newBuilder = builder.maximumWeight(this.maxMemory).recordStats().weigher((Weigher)weigher).concurrencyLevel(concurrency).removalListener((RemovalListener)new RemovalListener<String, TileObject>(){

            public void onRemoval(RemovalNotification<String, TileObject> notification) {
                TileObject obj = (TileObject)notification.getValue();
                GuavaCacheProvider.this.currentSize.addAndGet(-obj.getBlobSize());
                String tileKey = GuavaCacheProvider.generateTileKey(obj);
                String layerName = obj.getLayerName();
                GuavaCacheProvider.this.multimap.removeTile(layerName, tileKey);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Removed tile " + tileKey + " for layer " + layerName + " due to reason:" + notification.getCause().toString()));
                    LOGGER.debug((Object)("Removed tile was evicted? " + notification.wasEvicted()));
                }
            }
        });
        boolean configuredPolicy = false;
        if (policy != null && evictionTime > 0L) {
            if (policy == CacheConfiguration.EvictionPolicy.EXPIRE_AFTER_ACCESS) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Configuring Expire After Access eviction policy");
                }
                newBuilder.expireAfterAccess(evictionTime, TimeUnit.SECONDS);
                configuredPolicy = true;
            } else if (policy == CacheConfiguration.EvictionPolicy.EXPIRE_AFTER_WRITE) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Configuring Expire After Write eviction policy");
                }
                newBuilder.expireAfterWrite(evictionTime, TimeUnit.SECONDS);
                configuredPolicy = true;
            }
        }
        this.cache = newBuilder.build();
        this.multimap = new LayerMap();
        if (configuredPolicy) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Configuring Scheduled Task for cache eviction");
            }
            Runnable command = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (GuavaCacheProvider.this.configured.get()) {
                        GuavaCacheProvider.this.actualOperations.incrementAndGet();
                        try {
                            GuavaCacheProvider.this.cache.cleanUp();
                        }
                        finally {
                            GuavaCacheProvider.this.actualOperations.decrementAndGet();
                        }
                    }
                }
            };
            this.scheduledPool = Executors.newScheduledThreadPool(1);
            this.scheduledPool.scheduleAtFixedRate(command, 10L, evictionTime + 1L, TimeUnit.SECONDS);
        }
        this.configured.getAndSet(true);
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public synchronized void configure(CacheConfiguration configuration) {
        this.reset();
        this.initCache(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TileObject getTileObj(TileObject obj) {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Checking if the layer must not be cached");
                }
                if (this.layers.contains(obj.getLayerName())) {
                    TileObject tileObject = null;
                    return tileObject;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Retrieving TileObject: " + obj + " from cache"));
                }
                String id = GuavaCacheProvider.generateTileKey(obj);
                TileObject tileObject = (TileObject)this.cache.getIfPresent((Object)id);
                return tileObject;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putTileObj(TileObject obj) {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Checking if the layer must not be cached");
                }
                if (this.layers.contains(obj.getLayerName())) {
                    return;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Adding TileObject: " + obj + " to cache"));
                }
                String id = GuavaCacheProvider.generateTileKey(obj);
                this.cache.put((Object)id, (Object)obj);
                this.multimap.putTile(obj.getLayerName(), id);
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTileObj(TileObject obj) {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Checking if the layer must not be cached");
                }
                if (this.layers.contains(obj.getLayerName())) {
                    return;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Removing TileObject: " + obj + " from cache"));
                }
                String id = GuavaCacheProvider.generateTileKey(obj);
                this.cache.invalidate((Object)id);
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayer(String layername) {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                Set<String> keys;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Checking if the layer must not be cached");
                }
                if (this.layers.contains(layername)) {
                    return;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Removing Layer: " + layername + " from cache"));
                }
                if ((keys = this.multimap.removeLayer(layername)) != null) {
                    this.cache.invalidateAll(keys);
                }
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Flushing cache");
                }
                if (this.cache != null) {
                    this.cache.invalidateAll();
                }
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reset() {
        if (this.configured.getAndSet(false)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Reset Cache internally");
            }
            this.actualOperations.incrementAndGet();
            this.actualOperations.decrementAndGet();
            while (this.actualOperations.get() > 0L) {
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Flushing cache");
            }
            if (this.cache != null) {
                this.cache.invalidateAll();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Removing Layers");
            }
            this.layers.clear();
            if (this.scheduledPool == null) return;
            this.scheduledPool.shutdown();
            try {
                this.scheduledPool.awaitTermination(10L, TimeUnit.SECONDS);
                return;
            }
            catch (InterruptedException e) {
                if (!LOGGER.isErrorEnabled()) return;
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
            finally {
                this.scheduledPool = null;
            }
        } else {
            if (!LOGGER.isDebugEnabled()) return;
            LOGGER.debug((Object)"Cache is already reset");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheStatistics getStatistics() {
        if (this.configured.get()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Retrieving statistics");
            }
            this.actualOperations.incrementAndGet();
            try {
                long actualSize = this.currentSize.get();
                long currentSpace = (long)(100.0 - 1.0 * (100.0 * (1.0 * (double)(this.maxMemory - actualSize)) / (double)this.maxMemory));
                if (currentSpace < 0L) {
                    currentSpace = 0L;
                }
                GuavaCacheStatistics guavaCacheStatistics = new GuavaCacheStatistics(this.cache.stats(), currentSpace, actualSize, this.maxMemory);
                return guavaCacheStatistics;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Returning empty statistics");
        }
        return new CacheStatistics();
    }

    public static String generateTileKey(TileObject obj) {
        Map<String, String> parameters = obj.getParameters();
        StringBuilder builder = new StringBuilder(obj.getLayerName()).append(SEPARATOR).append(obj.getGridSetId()).append(SEPARATOR).append(Arrays.toString(obj.getXYZ())).append(SEPARATOR).append(obj.getBlobFormat());
        if (parameters != null && !parameters.isEmpty()) {
            for (String key : parameters.keySet()) {
                builder.append(SEPARATOR).append(key).append(SEPARATOR).append(parameters.get(key));
            }
        }
        return builder.toString();
    }

    @Override
    public String getName() {
        return GUAVA_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUncachedLayer(String layername) {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Adding Layer:" + layername + " to avoid cache"));
                }
                this.layers.add(layername);
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUncachedLayer(String layername) {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Removing Layer:" + layername + " to avoid cache"));
                }
                this.layers.remove(layername);
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsUncachedLayer(String layername) {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Checking if Layer:" + layername + " must not be cached"));
                }
                boolean bl = this.layers.contains(layername);
                return bl;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        return false;
    }

    @Override
    public List<CacheConfiguration.EvictionPolicy> getSupportedPolicies() {
        return POLICIES;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    static class LayerMap {
        private final ReentrantReadWriteLock lock;
        private final ReentrantReadWriteLock.WriteLock writeLock;
        private final ReentrantReadWriteLock.ReadLock readLock;
        private final ConcurrentHashMap<String, Set<String>> layerMap = new ConcurrentHashMap();

        public LayerMap() {
            this.lock = new ReentrantReadWriteLock(true);
            this.writeLock = this.lock.writeLock();
            this.readLock = this.lock.readLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putTile(String layer, String id) {
            this.readLock.lock();
            Set<String> tileKeys = this.layerMap.get(layer);
            if (tileKeys == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("No KeySet for Layer: " + layer));
                }
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    tileKeys = this.layerMap.get(layer);
                    if (tileKeys == null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("Creating new KeySet for Layer: " + layer));
                        }
                        tileKeys = new ConcurrentSkipListSet<String>();
                        this.layerMap.put(layer, tileKeys);
                    }
                    this.readLock.lock();
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Add the TileObject id to the Map");
                }
                tileKeys.add(id);
            }
            finally {
                this.readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTile(String layer, String id) {
            block8: {
                this.readLock.lock();
                try {
                    Set<String> tileKeys = this.layerMap.get(layer);
                    if (tileKeys == null) break block8;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Remove TileObject id to the Map");
                    }
                    tileKeys.remove(id);
                    if (!tileKeys.isEmpty()) break block8;
                    this.readLock.unlock();
                    this.writeLock.lock();
                    try {
                        if (tileKeys.isEmpty()) {
                            this.removeLayer(layer);
                        }
                        this.readLock.lock();
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                }
                finally {
                    this.readLock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> removeLayer(String layer) {
            this.writeLock.lock();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Removing KeySet for Layer: " + layer));
                }
                Set<String> layers = this.layerMap.get(layer);
                this.layerMap.remove(layer);
                Set<String> set = layers;
                return set;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public static class GuavaCacheStatistics
    extends CacheStatistics {
        private static final long serialVersionUID = 1L;

        public GuavaCacheStatistics(CacheStats stats, double currentSpace, long actualSize, long totalSize) {
            this.setEvictionCount(stats.evictionCount());
            this.setHitCount(stats.hitCount());
            this.setMissCount(stats.missCount());
            this.setTotalCount(stats.requestCount());
            this.setHitRate((int)(stats.hitRate() * 100.0));
            this.setMissRate(100.0 - this.getHitRate());
            this.setCurrentMemoryOccupation(currentSpace);
            this.setActualSize(actualSize);
            this.setTotalSize(totalSize);
        }
    }
}

