/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.memory;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;

public class NullBlobStore
implements BlobStore {
    private Map<String, Properties> metadataMap = new HashMap<String, Properties>();
    private static final Log LOGGER = LogFactory.getLog(NullBlobStore.class);

    @Override
    public boolean delete(String layerName) throws StorageException {
        return true;
    }

    @Override
    public boolean deleteByGridsetId(String layerName, String gridSetId) throws StorageException {
        return true;
    }

    @Override
    public boolean delete(TileObject obj) throws StorageException {
        return true;
    }

    @Override
    public boolean delete(TileRange obj) throws StorageException {
        return true;
    }

    @Override
    public boolean get(TileObject obj) throws StorageException {
        return false;
    }

    @Override
    public void put(TileObject obj) throws StorageException {
    }

    @Override
    public void clear() throws StorageException {
    }

    @Override
    public synchronized void destroy() {
        this.metadataMap.clear();
    }

    @Override
    public void addListener(BlobStoreListener listener) {
    }

    @Override
    public boolean removeListener(BlobStoreListener listener) {
        return true;
    }

    @Override
    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        return true;
    }

    @Override
    public synchronized String getLayerMetadata(String layerName, String key) {
        Properties properties = this.metadataMap.get(layerName);
        if (properties != null) {
            return (String)properties.get(key);
        }
        return null;
    }

    @Override
    public synchronized void putLayerMetadata(String layerName, String key, String value) {
        Properties props = this.metadataMap.get(layerName);
        if (props != null) {
            try {
                props.setProperty(key, URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            props = new Properties();
            try {
                props.setProperty(key, URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            this.metadataMap.put(layerName, props);
        }
    }

    @Override
    public boolean layerExists(String layerName) {
        return false;
    }
}

