/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.memory;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.memory.CacheConfiguration;
import org.geowebcache.storage.blobstore.memory.CacheProvider;
import org.geowebcache.storage.blobstore.memory.CacheStatistics;
import org.geowebcache.storage.blobstore.memory.NullBlobStore;
import org.geowebcache.storage.blobstore.memory.guava.GuavaCacheProvider;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MemoryBlobStore
implements BlobStore,
ApplicationContextAware {
    private static final Log LOG = LogFactory.getLog(MemoryBlobStore.class);
    private BlobStore store;
    private CacheProvider cacheProvider;
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private String cacheBeanName;
    private AtomicBoolean cacheAlreadySet;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.WriteLock blobStoreStateLock = this.lock.writeLock();
    private final ReentrantReadWriteLock.ReadLock componentsStateLock = this.lock.readLock();

    public MemoryBlobStore() {
        this.cacheAlreadySet = new AtomicBoolean(false);
        this.setStore(new NullBlobStore());
        GuavaCacheProvider startingCache = new GuavaCacheProvider(new CacheConfiguration());
        this.cacheProvider = startingCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean layerExists(String layerName) {
        this.componentsStateLock.lock();
        try {
            boolean bl = this.store.layerExists(layerName);
            return bl;
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String layerName) throws StorageException {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing layer: " + layerName + " from cache provider"));
            }
            this.cacheProvider.removeLayer(layerName);
            boolean executed = this.executeBlobStoreTask(BlobStoreAction.DELETE_LAYER, this.store, layerName);
            if (LOG.isDebugEnabled()) {
                if (executed) {
                    LOG.debug((Object)"Delete Layer Task executed");
                } else {
                    LOG.debug((Object)"Delete LayerTask failed");
                }
            }
            boolean bl = executed;
            return bl;
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteByGridsetId(String layerName, String gridSetId) throws StorageException {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing Layer: " + layerName));
            }
            this.cacheProvider.removeLayer(layerName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Scheduling GridSet: " + gridSetId + " removal for Layer: " + layerName));
            }
            this.executorService.submit(new BlobStoreTask(this.store, BlobStoreAction.DELETE_GRIDSET, layerName, gridSetId));
            boolean bl = true;
            return bl;
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(TileObject obj) throws StorageException {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing TileObject: " + obj));
            }
            this.cacheProvider.removeTileObj(obj);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Scheduling removal of TileObject: " + obj));
            }
            this.executorService.submit(new BlobStoreTask(this.store, BlobStoreAction.DELETE_SINGLE, obj));
            boolean bl = true;
            return bl;
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(TileRange obj) throws StorageException {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing TileObjects for Layer: " + obj.getLayerName() + ", min/max levels: " + "[" + obj.getZoomStart() + ", " + obj.getZoomStop() + "], Gridset: " + obj.getGridSetId()));
            }
            this.cacheProvider.removeLayer(obj.getLayerName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Scheduling removal of TileObjects for Layer: " + obj.getLayerName() + ", min/max levels: " + "[" + obj.getZoomStart() + ", " + obj.getZoomStop() + "], Gridset: " + obj.getGridSetId()));
            }
            this.executorService.submit(new BlobStoreTask(this.store, BlobStoreAction.DELETE_RANGE, obj));
            boolean bl = true;
            return bl;
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean get(TileObject obj) throws StorageException {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking if TileObject:" + obj + " is present"));
            }
            TileObject cached = this.cacheProvider.getTileObj(obj);
            boolean found = false;
            if (cached == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("TileObject:" + obj + " not found. Try to get it from the wrapped blobstore"));
                }
                if (found = this.executeBlobStoreTask(BlobStoreAction.GET, this.store, obj)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("TileObject:" + obj + " found. Put it in cache"));
                    }
                    cached = this.getByteResourceTile(obj);
                    this.cacheProvider.putTileObj(cached);
                }
            } else {
                found = true;
            }
            if (found) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("TileObject:" + obj + " found, update the input TileObject"));
                }
                Resource resource = cached.getBlob();
                obj.setBlob(resource);
                obj.setCreated(resource.getLastModified());
                obj.setBlobSize((int)resource.getSize());
            }
            boolean bl = found;
            return bl;
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(TileObject obj) throws StorageException {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Convert Input resource into a Byte Array");
            }
            TileObject cached = this.getByteResourceTile(obj);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding TileObject: " + obj + " to cache"));
            }
            this.cacheProvider.putTileObj(cached);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding TileObject: " + obj + " to the wrapped blobstore"));
            }
            this.executeBlobStoreTask(BlobStoreAction.PUT, this.store, obj);
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws StorageException {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Flushing cache");
            }
            this.cacheProvider.clear();
            this.executorService.submit(new BlobStoreTask(this.store, BlobStoreAction.CLEAR, ""));
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.blobStoreStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Reset cache");
            }
            this.cacheProvider.reset();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Destroy wrapped store");
            }
            this.executeBlobStoreTask(BlobStoreAction.DESTROY, this.store, "");
            this.executorService.shutdownNow();
        }
        finally {
            this.blobStoreStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(BlobStoreListener listener) {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Adding a new Listener");
            }
            this.store.addListener(listener);
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(BlobStoreListener listener) {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Removing listener");
            }
            boolean bl = this.store.removeListener(listener);
            return bl;
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        this.componentsStateLock.lock();
        try {
            boolean executed;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Flushing cache");
            }
            this.cacheProvider.clear();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Executing Layer rename task");
            }
            boolean bl = executed = this.executeBlobStoreTask(BlobStoreAction.RENAME, this.store, oldLayerName, newLayerName);
            return bl;
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLayerMetadata(String layerName, String key) {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting metadata for Layer: " + layerName));
            }
            String string = this.store.getLayerMetadata(layerName, key);
            return string;
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLayerMetadata(String layerName, String key, String value) {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding metadata for Layer: " + layerName));
            }
            this.store.putLayerMetadata(layerName, key, value);
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheStatistics getCacheStatistics() {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Getting Cache Statistics");
            }
            CacheStatistics cacheStatistics = this.cacheProvider.getStatistics();
            return cacheStatistics;
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStore(BlobStore store) {
        this.blobStoreStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Setting the wrapped store");
            }
            if (store == null) {
                throw new NullPointerException("Input BlobStore cannot be null");
            }
            this.store = store;
        }
        finally {
            this.blobStoreStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobStore getStore() {
        this.componentsStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Returning the wrapped store");
            }
            BlobStore blobStore = this.store;
            return blobStore;
        }
        finally {
            this.componentsStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheProvider(CacheProvider cache) {
        this.blobStoreStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Setting cache provided");
            }
            if (cache == null) {
                throw new IllegalArgumentException("Input BlobStore cannot be null");
            }
            this.cacheProvider = cache;
            this.cacheAlreadySet.getAndSet(true);
        }
        finally {
            this.blobStoreStateLock.unlock();
        }
    }

    private TileObject getByteResourceTile(TileObject obj) throws StorageException {
        ByteArrayResource finalBlob;
        Resource blob = obj.getBlob();
        if (obj.getBlob() instanceof ByteArrayResource) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Resource is already a Byte Array, only a copy is needed");
            }
            ByteArrayResource byteArrayResource = (ByteArrayResource)obj.getBlob();
            byte[] contents = byteArrayResource.getContents();
            byte[] copy = new byte[contents.length];
            System.arraycopy(contents, 0, copy, 0, contents.length);
            finalBlob = new ByteArrayResource(copy);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Resource is not a Byte Array, data must be transferred");
            }
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            WritableByteChannel wChannel = Channels.newChannel((OutputStream)bOut);
            try {
                blob.transferTo(wChannel);
            }
            catch (IOException e) {
                throw new StorageException(e.getLocalizedMessage(), e);
            }
            finalBlob = new ByteArrayResource(bOut.toByteArray());
        }
        TileObject cached = TileObject.createCompleteTileObject(obj.getLayerName(), obj.getXYZ(), obj.getGridSetId(), obj.getBlobFormat(), obj.getParameters(), finalBlob);
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheBeanName(String cacheBeanName) {
        this.blobStoreStateLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Setting cache providee name");
            }
            this.cacheBeanName = cacheBeanName;
        }
        finally {
            this.blobStoreStateLock.unlock();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (!this.cacheAlreadySet.get()) {
            String[] beans = applicationContext.getBeanNamesForType(CacheProvider.class);
            int beanSize = beans.length;
            boolean configured = false;
            if (beanSize > 0) {
                CacheProvider bean;
                CacheProvider bean2;
                if (this.cacheBeanName != null && !this.cacheBeanName.isEmpty()) {
                    for (String beanDef : beans) {
                        if (!this.cacheBeanName.equalsIgnoreCase(beanDef) || !(bean2 = (CacheProvider)applicationContext.getBean(beanDef, CacheProvider.class)).isAvailable()) continue;
                        this.setCacheProvider(bean2);
                        configured = true;
                        break;
                    }
                }
                if (!configured && beanSize == 1 && (bean = (CacheProvider)applicationContext.getBean(beans[0], CacheProvider.class)).isAvailable()) {
                    this.setCacheProvider(bean);
                    configured = true;
                }
                if (!configured && beanSize == 2) {
                    for (String beanDef : beans) {
                        bean2 = (CacheProvider)applicationContext.getBean(beanDef, CacheProvider.class);
                        if (bean2 instanceof GuavaCacheProvider || !bean2.isAvailable()) continue;
                        this.setCacheProvider(bean2);
                        configured = true;
                        break;
                    }
                    if (!configured) {
                        for (String beanDef : beans) {
                            bean2 = (CacheProvider)applicationContext.getBean(beanDef, CacheProvider.class);
                            if (!bean2.isAvailable()) continue;
                            this.setCacheProvider(bean2);
                            configured = true;
                            break;
                        }
                    }
                }
                if (!configured && LOG.isDebugEnabled()) {
                    LOG.debug((Object)"CacheProvider not configured, use default configuration");
                }
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"CacheProvider already configured");
        }
    }

    private boolean executeBlobStoreTask(BlobStoreAction action, BlobStore store, Object ... objs) {
        boolean executed;
        block3: {
            Future<Boolean> future = this.executorService.submit(new BlobStoreTask(store, action, objs));
            executed = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Waiting scheduled Tasks");
            }
            try {
                executed = future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return executed;
    }

    public static enum BlobStoreAction {
        PUT{

            @Override
            public boolean executeOperation(BlobStore store, Object ... objs) throws StorageException {
                if (objs == null || objs.length < 1 || !(objs[0] instanceof TileObject)) {
                    return false;
                }
                store.put((TileObject)objs[0]);
                return true;
            }
        }
        ,
        GET{

            @Override
            public boolean executeOperation(BlobStore store, Object ... objs) throws StorageException {
                if (objs == null || objs.length < 1 || !(objs[0] instanceof TileObject)) {
                    return false;
                }
                return store.get((TileObject)objs[0]);
            }
        }
        ,
        DELETE_SINGLE{

            @Override
            public boolean executeOperation(BlobStore store, Object ... objs) throws StorageException {
                if (objs == null || objs.length < 1 || !(objs[0] instanceof TileObject)) {
                    return false;
                }
                return store.delete((TileObject)objs[0]);
            }
        }
        ,
        DELETE_RANGE{

            @Override
            public boolean executeOperation(BlobStore store, Object ... objs) throws StorageException {
                if (objs == null || objs.length < 1 || !(objs[0] instanceof TileRange)) {
                    return false;
                }
                return store.delete((TileRange)objs[0]);
            }
        }
        ,
        DELETE_GRIDSET{

            @Override
            public boolean executeOperation(BlobStore store, Object ... objs) throws StorageException {
                if (objs == null || objs.length < 2 || !(objs[0] instanceof String) || !(objs[1] instanceof String)) {
                    return false;
                }
                return store.deleteByGridsetId((String)objs[0], (String)objs[1]);
            }
        }
        ,
        DELETE_LAYER{

            @Override
            public boolean executeOperation(BlobStore store, Object ... objs) throws StorageException {
                if (objs == null || objs.length < 2 || !(objs[0] instanceof String)) {
                    return false;
                }
                return store.delete((String)objs[0]);
            }
        }
        ,
        CLEAR{

            @Override
            public boolean executeOperation(BlobStore store, Object ... objs) throws StorageException {
                store.clear();
                return true;
            }
        }
        ,
        DESTROY{

            @Override
            public boolean executeOperation(BlobStore store, Object ... objs) throws StorageException {
                store.destroy();
                return true;
            }
        }
        ,
        RENAME{

            @Override
            public boolean executeOperation(BlobStore store, Object ... objs) throws StorageException {
                if (objs == null || objs.length < 2 || !(objs[0] instanceof String) || !(objs[1] instanceof String)) {
                    return false;
                }
                return store.rename((String)objs[0], (String)objs[1]);
            }
        };


        public abstract boolean executeOperation(BlobStore var1, Object ... var2) throws StorageException;
    }

    static class BlobStoreTask
    implements Callable<Boolean> {
        private BlobStore store;
        private Object[] objs;
        private BlobStoreAction action;

        public BlobStoreTask(BlobStore store, BlobStoreAction action, Object ... objs) {
            this.objs = objs;
            this.store = store;
            this.action = action;
        }

        @Override
        public Boolean call() throws Exception {
            boolean result;
            block2: {
                result = false;
                try {
                    result = this.action.executeOperation(this.store, this.objs);
                }
                catch (StorageException s) {
                    if (!LOG.isErrorEnabled()) break block2;
                    LOG.error((Object)s.getMessage(), (Throwable)s);
                }
            }
            return result;
        }
    }
}

