/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.memory;

import java.io.Serializable;

public class CacheConfiguration
implements Serializable {
    private static final long serialVersionUID = 3875121032331372267L;
    public static final long DEFAULT_MEMORY_LIMIT = 16L;
    public static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    public static final long DEFAULT_EVICTION_TIME = 120L;
    public static final EvictionPolicy DEFAULT_EVICTION_POLICY = EvictionPolicy.NULL;
    private long hardMemoryLimit = 16L;
    private EvictionPolicy policy = DEFAULT_EVICTION_POLICY;
    private int concurrencyLevel = 4;
    private long evictionTime = 120L;

    public long getHardMemoryLimit() {
        return this.hardMemoryLimit;
    }

    public void setHardMemoryLimit(long hardMemoryLimit) {
        this.hardMemoryLimit = hardMemoryLimit;
    }

    public EvictionPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(EvictionPolicy policy) {
        this.policy = policy;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public void setConcurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
    }

    public long getEvictionTime() {
        return this.evictionTime;
    }

    public void setEvictionTime(long evictionTime) {
        this.evictionTime = evictionTime;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheConfiguration)) {
            return false;
        }
        CacheConfiguration config = (CacheConfiguration)obj;
        if (this.concurrencyLevel != config.concurrencyLevel) {
            return false;
        }
        if (this.policy != config.policy) {
            return false;
        }
        if (this.hardMemoryLimit != config.hardMemoryLimit) {
            return false;
        }
        return this.evictionTime == config.evictionTime;
    }

    public static enum EvictionPolicy {
        LRU,
        LFU,
        EXPIRE_AFTER_WRITE,
        EXPIRE_AFTER_ACCESS,
        NULL;


        public static EvictionPolicy getEvictionPolicy(String policy) {
            if (policy == null || policy.isEmpty()) {
                return NULL;
            }
            return EvictionPolicy.valueOf(policy);
        }
    }
}

