/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.blobstore.file.FilePathUtils;

public class FilePathGenerator {
    private static Log log = LogFactory.getLog(FilePathGenerator.class);
    String cacheRoot;

    public FilePathGenerator(String cacheRoot) {
        this.cacheRoot = cacheRoot;
    }

    public File tilePath(TileObject tile, MimeType mimeType) {
        long[] tileIndex = tile.getXYZ();
        long x = tileIndex[0];
        long y = tileIndex[1];
        long z = tileIndex[2];
        StringBuilder path = new StringBuilder(256);
        long shift = z / 2L;
        long half = 2 << (int)shift;
        int digits = 1;
        if (half > 10L) {
            digits = (int)Math.log10(half) + 1;
        }
        long halfx = x / half;
        long halfy = y / half;
        String fileExtension = mimeType.getFileExtension();
        path.append(this.cacheRoot);
        path.append(File.separatorChar);
        FilePathUtils.appendFiltered(tile.getLayerName(), path);
        path.append(File.separatorChar);
        FilePathUtils.appendGridsetZoomLevelDir(tile.getGridSetId(), z, path);
        String parametersId = tile.getParametersId();
        Map<String, String> parameters = tile.getParameters();
        if (parametersId == null && parameters != null && !parameters.isEmpty()) {
            parametersId = FilePathGenerator.getParametersId(parameters);
            tile.setParametersId(parametersId);
        }
        if (parametersId != null) {
            path.append('_');
            path.append(parametersId);
        }
        path.append(File.separatorChar);
        FilePathUtils.zeroPadder(halfx, digits, path);
        path.append('_');
        FilePathUtils.zeroPadder(halfy, digits, path);
        path.append(File.separatorChar);
        FilePathUtils.zeroPadder(x, 2 * digits, path);
        path.append('_');
        FilePathUtils.zeroPadder(y, 2 * digits, path);
        path.append('.');
        path.append(fileExtension);
        File tileFile = new File(path.toString());
        return tileFile;
    }

    protected static String buildKey(String parametersKvp) {
        return DigestUtils.shaHex((String)parametersKvp);
    }

    public static String getParametersId(Map<String, String> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return null;
        }
        String parametersKvp = FilePathGenerator.getParametersKvp(parameters);
        return FilePathGenerator.buildKey(parametersKvp);
    }

    public static String getParametersKvp(Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> sorted = new TreeMap<String, String>(parameters);
        for (Map.Entry e : sorted.entrySet()) {
            if (sb.length() == 0) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            sb.append((String)e.getKey()).append('=').append((String)e.getValue());
        }
        String paramtersKvp = sb.toString();
        return paramtersKvp;
    }
}

