/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FilenameFilter;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.file.FilePathUtils;

public class FilePathFilter
implements FilenameFilter {
    private final String gridSetPrefix;
    private String mimeExtension;
    private TileRange tr;
    private String layerPrefix;

    public FilePathFilter(TileRange trObj) throws StorageException {
        this.tr = trObj;
        if (this.tr.getGridSetId() == null) {
            throw new StorageException("Specifying the grid set id is currently mandatory.");
        }
        String layerName = this.tr.getLayerName();
        Preconditions.checkNotNull((Object)layerName);
        this.layerPrefix = FilePathUtils.filteredLayerName(layerName);
        this.gridSetPrefix = FilePathUtils.filteredGridSetId(this.tr.getGridSetId());
        if (this.tr.getMimeType() != null) {
            this.mimeExtension = this.tr.getMimeType().getFileExtension();
        }
    }

    @Override
    public boolean accept(File parent, String fileName) {
        boolean ret = false;
        if (fileName.startsWith(this.gridSetPrefix)) {
            ret = this.acceptZoomLevelDir(fileName);
        } else if (fileName.contains(".")) {
            ret = this.acceptFileName(parent, fileName);
        } else if (!parent.getName().equals(this.layerPrefix)) {
            ret = this.acceptIntermediateDir(fileName);
        }
        return ret;
    }

    private boolean acceptZoomLevelDir(String name) {
        if (!name.startsWith(this.gridSetPrefix)) {
            return false;
        }
        if (this.tr.getZoomStart() == -1 && this.tr.getZoomStop() == -1) {
            return true;
        }
        int tmp = FilePathUtils.findZoomLevel(this.gridSetPrefix, name);
        if (tmp < this.tr.getZoomStart() || tmp > this.tr.getZoomStop()) {
            return false;
        }
        String parameter = FilePathUtils.findParameter(this.gridSetPrefix, name);
        if (this.tr.getParametersId() == null) {
            return parameter == null;
        }
        return this.tr.getParametersId().equals(parameter);
    }

    private boolean acceptIntermediateDir(String name) {
        return true;
    }

    private boolean acceptFileName(File parent, String name) {
        String[] parts = name.split("\\.");
        if (!parts[parts.length - 1].equalsIgnoreCase(this.mimeExtension)) {
            return false;
        }
        String[] coords = parts[0].split("_");
        int zoomLevel = FilePathUtils.findZoomLevel(this.gridSetPrefix, parent.getParentFile().getName());
        long x = Long.parseLong(coords[0]);
        long y = Long.parseLong(coords[1]);
        boolean contains = this.tr.contains(x, y, zoomLevel);
        return contains;
    }
}

