/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;

public class TransientCache {
    private final int maxTiles;
    private final int maxStorage;
    private final long expireDelay;
    private long currentStorage;
    private Ticker ticker = Ticker.systemTicker();
    private static FilePathGenerator keyGenerator = new FilePathGenerator("");
    private Map<String, CachedResource> cache = new LinkedHashMap<String, CachedResource>(){
        private static final long serialVersionUID = -4106644240603796847L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CachedResource> eldest) {
            return TransientCache.this.removeEntries(eldest);
        }
    };

    public TransientCache(int maxTiles, int maxStorageKB) {
        this(maxTiles, maxStorageKB, 2000L);
    }

    public TransientCache(int maxTiles, int maxStorageKB, long expireDelay) {
        this.maxTiles = maxTiles;
        this.maxStorage = maxStorageKB * 1024;
        this.expireDelay = expireDelay;
    }

    public int size() {
        return this.cache.size();
    }

    public long storageSize() {
        return this.currentStorage;
    }

    public void put(String key, Resource r) {
        byte[] buf = new byte[(int)r.getSize()];
        try {
            r.getInputStream().read(buf);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        CachedResource blob = new CachedResource(new ByteArrayResource(buf));
        this.currentStorage += r.getSize();
        this.cache.put(key, blob);
    }

    public Resource get(String key) {
        CachedResource cached = this.cache.get(key);
        if (cached != null) {
            this.cache.remove(key);
            this.currentStorage -= cached.content.getSize();
            if (cached.time + this.expireDelay < this.currentTime()) {
                return null;
            }
            return cached.content;
        }
        return null;
    }

    protected long currentTime() {
        return this.ticker.read() / 1000L;
    }

    private boolean removeEntries(Map.Entry<String, CachedResource> eldest) {
        Iterator<CachedResource> items = this.cache.values().iterator();
        while (items.hasNext() && (this.currentStorage > (long)this.maxStorage || this.cache.size() > this.maxTiles)) {
            CachedResource r = items.next();
            this.currentStorage -= r.content.getSize();
            items.remove();
        }
        assert (this.currentStorage <= (long)this.maxStorage);
        assert (this.currentStorage >= 0L);
        assert (this.cache.size() <= this.maxStorage);
        return false;
    }

    public static String computeTransientKey(TileObject tile) {
        try {
            MimeType mime = MimeType.createFromFormat(tile.getBlobFormat());
            return keyGenerator.tilePath(tile, mime).getAbsolutePath();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setTicker(Ticker ticker) {
        Preconditions.checkNotNull((Object)ticker);
        this.ticker = ticker;
    }

    private class CachedResource {
        Resource content;
        long time;

        public CachedResource(Resource content, long time) {
            this.content = content;
            this.time = time;
        }

        public CachedResource(Resource content) {
            this(content, transientCache.currentTime());
        }
    }
}

