/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.geowebcache.io.Resource;
import org.geowebcache.storage.StorageObject;

public class TileObject
extends StorageObject
implements Serializable {
    public static final String TYPE = "tile";
    Resource blob;
    String parameters_id = null;
    long[] xyz;
    String layer_name;
    Map<String, String> parameters;
    String gridSetId;

    public static TileObject createQueryTileObject(String layerName, long[] xyz, String gridSetId, String format, Map<String, String> parameters) {
        TileObject obj = new TileObject();
        obj.layer_name = layerName;
        obj.xyz = xyz;
        obj.gridSetId = gridSetId;
        obj.blob_format = format;
        obj.parameters = parameters;
        return obj;
    }

    public static TileObject createCompleteTileObject(String layerName, long[] xyz, String gridSetId, String format, Map<String, String> parameters, Resource blob) {
        TileObject obj = new TileObject();
        obj.layer_name = layerName;
        obj.xyz = xyz;
        obj.gridSetId = gridSetId;
        obj.blob_format = format;
        obj.parameters = parameters;
        if (blob == null) {
            obj.blob_size = -1;
        } else {
            obj.blob_size = (int)blob.getSize();
            obj.blob = blob;
        }
        obj.created = System.currentTimeMillis();
        return obj;
    }

    private TileObject() {
    }

    public Resource getBlob() {
        return this.blob;
    }

    public void setBlob(Resource blob) {
        this.blob_size = blob != null ? (int)blob.getSize() : -1;
        this.blob = blob;
    }

    public String getGridSetId() {
        return this.gridSetId;
    }

    public String getParametersId() {
        return this.parameters_id;
    }

    public void setParametersId(String parameters_id) {
        this.parameters_id = parameters_id;
    }

    public long[] getXYZ() {
        return this.xyz;
    }

    public String getLayerName() {
        return this.layer_name;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String toString() {
        return "[" + this.layer_name + "," + this.gridSetId + ",{" + Arrays.toString(this.xyz) + "}]";
    }
}

