/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.geowebcache.storage.TileRangeMask;

public class RasterMask
implements TileRangeMask {
    private final BufferedImage[] byLevelMasks;
    private final long[][] coveredBounds;
    private final int maxMaskLevel;
    private final int noDataValue;
    private long[][] fullCoverage;

    public RasterMask(BufferedImage[] byLevelMasks, long[][] fullCoverage, long[][] coveredBounds) {
        this(byLevelMasks, fullCoverage, coveredBounds, 0);
    }

    public RasterMask(BufferedImage[] byLevelMasks, long[][] fullCoverage, long[][] coveredBounds, int noDataValue) {
        this.byLevelMasks = byLevelMasks;
        this.fullCoverage = fullCoverage;
        this.coveredBounds = coveredBounds;
        this.maxMaskLevel = byLevelMasks.length - 1;
        this.noDataValue = noDataValue;
    }

    @Override
    public long[][] getGridCoverages() {
        return this.coveredBounds;
    }

    public boolean lookup(long[] idx) {
        return this.lookup(idx[0], idx[1], (int)idx[2]);
    }

    @Override
    public boolean lookup(long x, long y, int z) {
        long tileX = x;
        long tileY = y;
        int level = z;
        long[] coverage = this.getGridCoverages()[level];
        if (tileX < coverage[0] || tileX > coverage[2] || tileY < coverage[1] || tileY > coverage[3]) {
            return false;
        }
        if (level > this.maxMaskLevel) {
            long[] requestedCoverage = this.fullCoverage[level];
            long[] lastMaskedCoverage = this.fullCoverage[this.maxMaskLevel];
            double requestedW = requestedCoverage[2] - requestedCoverage[0];
            double requestedH = requestedCoverage[3] - requestedCoverage[1];
            double availableW = lastMaskedCoverage[2] - lastMaskedCoverage[0];
            double availableH = lastMaskedCoverage[3] - lastMaskedCoverage[1];
            tileX = Math.round((double)tileX * (availableW / requestedW));
            tileY = Math.round((double)tileY * (availableH / requestedH));
            level = this.maxMaskLevel;
        }
        return this.isTileSet(tileX, tileY, level);
    }

    private boolean isTileSet(long tileX, long tileY, int level) {
        long[] coverage = this.getGridCoverages()[level];
        if (tileX < coverage[0] || tileX > coverage[2] || tileY < coverage[1] || tileY > coverage[3]) {
            return false;
        }
        WritableRaster raster = this.byLevelMasks[level].getRaster();
        long rasx = tileX;
        long rasy = (long)(raster.getHeight() - 1) - tileY;
        if (rasx < 0L || rasy < 0L || rasx >= (long)raster.getWidth() || rasy >= (long)raster.getHeight()) {
            return false;
        }
        int sample = raster.getSample((int)rasx, (int)rasy, 0);
        return sample != this.noDataValue;
    }
}

