/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;
import org.geowebcache.storage.blobstore.file.FilePathUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class MetastoreRemover {
    private static Log log = LogFactory.getLog(MetastoreRemover.class);
    private DefaultStorageFinder storageFinder;
    private boolean defaultLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetastoreRemover(DefaultStorageFinder finder) throws Exception {
        File version;
        String path;
        File quotaRoot;
        File dbFile;
        this.storageFinder = finder;
        File root = new File(this.storageFinder.getDefaultPath());
        try (Connection conn = null;){
            conn = this.getMetaStoreConnection(root);
            if (conn != null) {
                log.info((Object)"Migrating the old metastore to filesystem storage");
                SingleConnectionDataSource ds = new SingleConnectionDataSource(conn, false);
                JdbcTemplate template = new JdbcTemplate((DataSource)ds);
                boolean migrateCreationDates = Boolean.getBoolean("MIGRATE_CREATION_DATES");
                if (migrateCreationDates) {
                    this.migrateTileDates(template, new FilePathGenerator(root.getPath()));
                }
                this.migrateParameters(template, root);
                if (!this.defaultLocation) {
                    this.removeTiles(template);
                }
            }
        }
        if (this.defaultLocation && (dbFile = this.getDefaultH2Path(root).getParentFile()).exists()) {
            log.info((Object)"Cleaning up the old H2 database");
            FileUtils.deleteDirectory((File)dbFile);
        }
        if ((quotaRoot = new File(path = root.getPath() + File.separator + "diskquota_page_store")).exists() && !(version = new File(quotaRoot, "version.txt")).exists()) {
            log.warn((Object)"Old style DiskQuota database found, removing it.");
            FileUtils.deleteDirectory((File)quotaRoot);
        }
    }

    private void removeTiles(JdbcTemplate template) {
        template.execute("delete from tiles");
    }

    private void migrateParameters(JdbcTemplate template, final File root) {
        String query = "select layers.value as layer, gridsets.value as gridset, tiles.z, parameters.value as parameters, parameters_id\nfrom tiles join layers on layers.id = tiles.layer_id \n     join gridsets on gridsets.id = tiles.gridset_id\n     join parameters on parameters.id = tiles.parameters_id\ngroup by layer, gridset, z, parameters, parameters_id";
        final long total = template.queryForLong("select count(*) from (" + query + ")");
        log.info((Object)("Migrating " + total + " parameters from the metastore to the file system"));
        template.query(query, new RowCallbackHandler(){
            long count = 0L;

            public void processRow(ResultSet rs) throws SQLException {
                String layer = rs.getString(1);
                String gridset = rs.getString(2);
                int z = rs.getInt(3);
                String paramsKvp = rs.getString(4);
                String paramsId = rs.getString(5);
                String sha = this.getParamsSha1(paramsKvp);
                File origin = new File(this.buildFolderPath(root, layer, gridset, z, paramsId));
                File destination = new File(this.buildFolderPath(root, layer, gridset, z, sha));
                org.geowebcache.util.FileUtils.renameFile(origin, destination);
                ++this.count;
                if (this.count % 1000L == 0L || this.count >= total) {
                    log.info((Object)("Migrated " + this.count + "/" + total + " parameters from the metastore to the file system"));
                }
            }

            private String buildFolderPath(File root2, String layer, String gridset, int z, String paramsId) {
                StringBuilder path = new StringBuilder();
                path.append(root2.getPath());
                path.append(File.separatorChar);
                FilePathUtils.appendFiltered(layer, path);
                path.append(File.separatorChar);
                FilePathUtils.appendGridsetZoomLevelDir(gridset, z, path);
                path.append('_');
                path.append(paramsId);
                path.append(File.separatorChar);
                return path.toString();
            }

            private String getParamsSha1(String paramsKvp) {
                Map<String, String> params = this.toMap(paramsKvp);
                return FilePathGenerator.getParametersId(params);
            }

            private Map<String, String> toMap(String paramsKvp) {
                String[] kvps;
                HashMap<String, String> result = new HashMap<String, String>();
                for (String kvp : kvps = paramsKvp.split("&")) {
                    if (kvp == null || "".equals(kvp)) continue;
                    String[] kv = kvp.split("=");
                    result.put(kv[0], kv[1]);
                }
                return result;
            }
        });
    }

    private void migrateTileDates(JdbcTemplate template, final FilePathGenerator generator) {
        String query = "select layers.value as layer, gridsets.value as gridset, tiles.parameters_id, tiles.z, tiles.x, tiles.y, created, formats.value as format \nfrom tiles join layers on layers.id = tiles.layer_id \njoin gridsets on gridsets.id = tiles.gridset_id \njoin formats on formats.id = tiles.format_id \norder by layer_id, parameters_id, gridset, z, x, y";
        final long total = template.queryForLong("select count(*) from (" + query + ")");
        log.info((Object)("Migrating " + total + " tile creation dates from the metastore to the file system"));
        template.query(query, new RowCallbackHandler(){
            int count = 0;

            public void processRow(ResultSet rs) throws SQLException {
                String layer = rs.getString(1);
                String gridset = rs.getString(2);
                String paramsId = rs.getString(3);
                long z = rs.getLong(4);
                long x = rs.getLong(5);
                long y = rs.getLong(6);
                long created = rs.getLong(7);
                String format = rs.getString(8);
                TileObject tile = TileObject.createCompleteTileObject(layer, new long[]{x, y, z}, gridset, format, null, null);
                tile.setParametersId(paramsId);
                try {
                    File file = generator.tilePath(tile, MimeType.createFromFormat(format));
                    if (file.exists()) {
                        file.setLastModified(created);
                    }
                }
                catch (MimeException e) {
                    log.error((Object)("Failed to locate mime type for format '" + format + "', this should never happen!"));
                }
                ++this.count;
                if (this.count % 10000 == 0 || (long)this.count >= total) {
                    log.info((Object)("Migrated " + this.count + "/" + total + " tile creation dates from the metastore to the file system"));
                }
            }
        });
    }

    private String getVariable(String variable, String defaultValue) {
        String value = this.storageFinder.findEnvVar("GWC_METASTORE_USERNAME");
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private Connection getMetaStoreConnection(File root) throws ClassNotFoundException, SQLException {
        try {
            File dbPath;
            String username = this.getVariable("GWC_METASTORE_USERNAME", "sa");
            String password = this.getVariable("GWC_METASTORE_PASSWORD", "");
            String defaultJDBCURL = this.getDefaultJDBCURL(root);
            String jdbcString = this.getVariable("GWC_METASTORE_JDBC_URL", defaultJDBCURL);
            String driver = this.getVariable("GWC_METASTORE_DRIVER_CLASS", "org.h2.Driver");
            if (defaultJDBCURL.equals(jdbcString)) {
                this.defaultLocation = true;
            }
            Class.forName(driver);
            if ("org.h2.Driver".equals(driver) && jdbcString.equals(defaultJDBCURL) && !(dbPath = this.getDefaultH2Path(root)).exists()) {
                return null;
            }
            return DriverManager.getConnection(jdbcString, username, password);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"Could not find the metastore driver, skipping migration", (Throwable)e);
            return null;
        }
        catch (SQLException e) {
            log.warn((Object)"Failed to connect to the legacy metastore, skipping migration", (Throwable)e);
            return null;
        }
    }

    private File getDefaultH2Path(File root) {
        String path = root.getPath() + File.separator + "meta_jdbc_h2";
        File dbPath = new File(path + File.separator + "gwc_metastore.data.db");
        return dbPath;
    }

    private String getDefaultJDBCURL(File root) {
        String path = root.getPath() + File.separator + "meta_jdbc_h2";
        String jdbcString = "jdbc:h2:file:" + path + File.separator + "gwc_metastore" + ";TRACE_LEVEL_FILE=0;AUTO_SERVER=TRUE";
        return jdbcString;
    }
}

