/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.io.Resource;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.TransientCache;

public class DefaultStorageBroker
implements StorageBroker {
    private static Log log = LogFactory.getLog(DefaultStorageBroker.class);
    private BlobStore blobStore;
    private TransientCache transientCache;

    @Deprecated
    public DefaultStorageBroker(BlobStore blobStore) {
        this(blobStore, new TransientCache(100, 1024));
    }

    public DefaultStorageBroker(BlobStore blobStore, TransientCache transientCache) {
        this.blobStore = blobStore;
        this.transientCache = transientCache;
    }

    @Override
    public void addBlobStoreListener(BlobStoreListener listener) {
        this.blobStore.addListener(listener);
    }

    @Override
    public boolean removeBlobStoreListener(BlobStoreListener listener) {
        return this.blobStore.removeListener(listener);
    }

    @Override
    public boolean delete(String layerName) throws StorageException {
        return this.blobStore.delete(layerName);
    }

    @Override
    public boolean deleteByGridSetId(String layerName, String gridSetId) throws StorageException {
        return this.blobStore.deleteByGridsetId(layerName, gridSetId);
    }

    @Override
    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        return this.blobStore.rename(oldLayerName, newLayerName);
    }

    @Override
    public boolean delete(TileRange trObj) throws StorageException {
        return this.blobStore.delete(trObj);
    }

    @Override
    public boolean get(TileObject tileObj) throws StorageException {
        return this.blobStore.get(tileObj);
    }

    @Override
    public boolean put(TileObject tileObj) throws StorageException {
        this.blobStore.put(tileObj);
        return true;
    }

    @Override
    public void destroy() {
        log.info((Object)"Destroying StorageBroker");
    }

    @Override
    public String getLayerMetadata(String layerName, String key) {
        return this.blobStore.getLayerMetadata(layerName, key);
    }

    @Override
    public void putLayerMetadata(String layerName, String key, String value) {
        this.blobStore.putLayerMetadata(layerName, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getTransient(TileObject tile) {
        Resource resource;
        String key = TransientCache.computeTransientKey(tile);
        TransientCache transientCache = this.transientCache;
        synchronized (transientCache) {
            resource = this.transientCache.get(key);
        }
        tile.setBlob(resource);
        return resource != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putTransient(TileObject tile) {
        String key = TransientCache.computeTransientKey(tile);
        TransientCache transientCache = this.transientCache;
        synchronized (transientCache) {
            this.transientCache.put(key, tile.getBlob());
        }
    }

    public BlobStore getBlobStore() {
        return this.blobStore;
    }
}

