/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.BlobStoreConfig;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.FileBlobStoreConfig;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.BlobStoreListenerList;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.file.FileBlobStore;

public class CompositeBlobStore
implements BlobStore {
    private static Log log = LogFactory.getLog(CompositeBlobStore.class);
    public static final String DEFAULT_STORE_DEFAULT_ID = "_DEFAULT_STORE_";
    @VisibleForTesting
    Map<String, LiveStore> blobStores = new ConcurrentHashMap<String, LiveStore>();
    private TileLayerDispatcher layers;
    private DefaultStorageFinder defaultStorageFinder;
    private LockProvider lockProvider;
    private final ReadWriteLock configLock = new ReentrantReadWriteLock();
    private final BlobStoreListenerList listeners = new BlobStoreListenerList();

    public CompositeBlobStore(TileLayerDispatcher layers, DefaultStorageFinder defaultStorageFinder, XMLConfiguration configuration) throws StorageException, ConfigurationException {
        this.layers = layers;
        this.defaultStorageFinder = defaultStorageFinder;
        this.lockProvider = configuration.getLockProvider();
        this.blobStores = this.loadBlobStores(configuration.getBlobStores());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String layerName) throws StorageException {
        this.configLock.readLock().lock();
        try {
            boolean bl = this.store(layerName).delete(layerName);
            return bl;
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteByGridsetId(String layerName, String gridSetId) throws StorageException {
        this.configLock.readLock().lock();
        try {
            boolean bl = this.store(layerName).deleteByGridsetId(layerName, gridSetId);
            return bl;
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(TileObject obj) throws StorageException {
        this.configLock.readLock().lock();
        try {
            boolean bl = this.store(obj.getLayerName()).delete(obj);
            return bl;
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(TileRange obj) throws StorageException {
        this.configLock.readLock().lock();
        try {
            boolean bl = this.store(obj.getLayerName()).delete(obj);
            return bl;
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean get(TileObject obj) throws StorageException {
        this.configLock.readLock().lock();
        try {
            boolean bl = this.store(obj.getLayerName()).get(obj);
            return bl;
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(TileObject obj) throws StorageException {
        this.configLock.readLock().lock();
        try {
            this.store(obj.getLayerName()).put(obj);
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    @Override
    @Deprecated
    public void clear() throws StorageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void destroy() {
        this.destroy(this.blobStores);
    }

    private void destroy(Map<String, LiveStore> blobStores) {
        for (LiveStore bs : blobStores.values()) {
            try {
                if (!bs.config.isEnabled()) continue;
                bs.liveInstance.destroy();
            }
            catch (Exception e) {
                log.error((Object)("Error disposing BlobStore " + bs.config.getId()), (Throwable)e);
            }
        }
        blobStores.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(BlobStoreListener listener) {
        this.configLock.readLock().lock();
        try {
            this.listeners.addListener(listener);
            for (LiveStore bs : this.blobStores.values()) {
                if (!bs.config.isEnabled()) continue;
                bs.liveInstance.addListener(listener);
            }
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(BlobStoreListener listener) {
        this.configLock.readLock().lock();
        boolean removed = false;
        try {
            this.listeners.removeListener(listener);
            for (LiveStore bs : this.blobStores.values()) {
                if (!bs.config.isEnabled()) continue;
                removed |= bs.liveInstance.removeListener(listener);
            }
        }
        finally {
            this.configLock.readLock().unlock();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        this.configLock.readLock().lock();
        try {
            for (LiveStore bs : this.blobStores.values()) {
                BlobStoreConfig config = bs.config;
                if (!config.isEnabled() || !bs.liveInstance.rename(oldLayerName, newLayerName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.configLock.readLock().unlock();
        }
        return false;
    }

    @Override
    public String getLayerMetadata(String layerName, String key) {
        this.configLock.readLock().lock();
        try {
            String string = this.store(layerName).getLayerMetadata(layerName, key);
            return string;
        }
        catch (StorageException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    @Override
    public void putLayerMetadata(String layerName, String key, String value) {
        this.configLock.readLock().lock();
        try {
            this.store(layerName).putLayerMetadata(layerName, key, value);
        }
        catch (StorageException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean layerExists(String layerName) {
        this.configLock.readLock().lock();
        try {
            for (LiveStore bs : this.blobStores.values()) {
                if (!bs.config.isEnabled() || !bs.liveInstance.layerExists(layerName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.configLock.readLock().unlock();
        }
        return false;
    }

    private BlobStore store(String layerId) throws StorageException {
        LiveStore store;
        try {
            store = this.forLayer(layerId);
        }
        catch (GeoWebCacheException e) {
            throw new StorageException(e.getMessage(), e);
        }
        if (!store.config.isEnabled()) {
            throw new StorageException("Attempted to use a blob store that's disabled: " + store.config.getId());
        }
        return store.liveInstance;
    }

    private LiveStore forLayer(String layerName) throws StorageException, GeoWebCacheException {
        TileLayer layer = this.layers.getTileLayer(layerName);
        String storeId = layer.getBlobStoreId();
        LiveStore store = null == storeId ? this.defaultStore() : this.blobStores.get(storeId);
        if (store == null) {
            throw new StorageException("No BlobStore with id '" + storeId + "' found");
        }
        return store;
    }

    private LiveStore defaultStore() throws StorageException {
        LiveStore store = this.blobStores.get(DEFAULT_STORE_DEFAULT_ID);
        if (store == null) {
            throw new StorageException("No default BlobStore has been defined");
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlobStores(Iterable<? extends BlobStoreConfig> configs) throws StorageException, ConfigurationException {
        this.configLock.writeLock().lock();
        try {
            Map<String, LiveStore> newStores = this.loadBlobStores(configs);
            Map<String, LiveStore> oldStores = this.blobStores;
            this.blobStores = newStores;
            for (LiveStore ls : oldStores.values()) {
                if (ls.liveInstance == null) continue;
                ls.liveInstance.destroy();
            }
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }

    Map<String, LiveStore> loadBlobStores(Iterable<? extends BlobStoreConfig> configs) throws StorageException, ConfigurationException {
        HashMap<String, LiveStore> stores = new HashMap<String, LiveStore>();
        BlobStoreConfig defaultStore = null;
        try {
            for (BlobStoreConfig blobStoreConfig : configs) {
                String id = blobStoreConfig.getId();
                boolean enabled = blobStoreConfig.isEnabled();
                if (Strings.isNullOrEmpty((String)id)) {
                    throw new ConfigurationException("No id provided for blob store " + blobStoreConfig);
                }
                if (stores.containsKey(id)) {
                    throw new ConfigurationException("Duplicate blob store id: " + id + ". Check your configuration.");
                }
                if (DEFAULT_STORE_DEFAULT_ID.equals(id)) {
                    throw new ConfigurationException("_DEFAULT_STORE_ is a reserved identifier, please don't use it in the configuration");
                }
                BlobStore store = null;
                if (enabled) {
                    store = blobStoreConfig.createInstance(this.layers, this.lockProvider);
                }
                LiveStore liveStore = new LiveStore(blobStoreConfig, store);
                stores.put(blobStoreConfig.getId(), liveStore);
                if (!blobStoreConfig.isDefault()) continue;
                if (defaultStore == null) {
                    if (!enabled) {
                        throw new ConfigurationException("The default blob store can't be disabled: " + blobStoreConfig.getId());
                    }
                    defaultStore = blobStoreConfig;
                    stores.put(DEFAULT_STORE_DEFAULT_ID, liveStore);
                    continue;
                }
                throw new ConfigurationException("Duplicate default blob store: " + defaultStore.getId() + " and " + blobStoreConfig.getId());
            }
            if (!stores.containsKey(DEFAULT_STORE_DEFAULT_ID)) {
                FileBlobStoreConfig config = new FileBlobStoreConfig();
                config.setEnabled(true);
                config.setDefault(true);
                config.setBaseDirectory(this.defaultStorageFinder.getDefaultPath());
                FileBlobStore fileBlobStore = new FileBlobStore(config.getBaseDirectory());
                stores.put(DEFAULT_STORE_DEFAULT_ID, new LiveStore(config, fileBlobStore));
            }
        }
        catch (ConfigurationException | StorageException e) {
            this.destroy(stores);
            throw e;
        }
        return new ConcurrentHashMap<String, LiveStore>(stores);
    }

    @VisibleForTesting
    static final class LiveStore {
        BlobStoreConfig config;
        BlobStore liveInstance;

        public LiveStore(BlobStoreConfig config, @Nullable BlobStore store) {
            Preconditions.checkArgument((config.isEnabled() == (store != null) ? 1 : 0) != 0);
            this.config = config;
            this.liveInstance = store;
        }
    }
}

