/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.TileObject;

public final class BlobStoreListenerList {
    private List<BlobStoreListener> listeners = new CopyOnWriteArrayList<BlobStoreListener>();

    public Iterable<BlobStoreListener> getListeners() {
        return new ArrayList<BlobStoreListener>(this.listeners);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public synchronized void addListener(BlobStoreListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized boolean removeListener(BlobStoreListener listener) {
        return this.listeners.remove(listener);
    }

    public void sendLayerDeleted(String layerName) {
        if (this.listeners.size() > 0) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).layerDeleted(layerName);
            }
        }
    }

    public void sendLayerRenamed(String oldLayerName, String newLayerName) {
        if (this.listeners.size() > 0) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).layerRenamed(oldLayerName, newLayerName);
            }
        }
    }

    public void sendGridSubsetDeleted(String layerName, String gridSetId) {
        if (this.listeners.size() > 0) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).gridSubsetDeleted(layerName, gridSetId);
            }
        }
    }

    public void sendTileDeleted(String layerName, String gridSetId, String blobFormat, String parametersId, long x, long y, int z, long length) {
        if (this.listeners.size() > 0) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).tileDeleted(layerName, gridSetId, blobFormat, parametersId, x, y, z, length);
            }
        }
    }

    public void sendTileDeleted(TileObject stObj) {
        if (this.listeners.size() > 0) {
            long[] xyz = stObj.getXYZ();
            String layerName = stObj.getLayerName();
            String gridSetId = stObj.getGridSetId();
            String blobFormat = stObj.getBlobFormat();
            String paramsId = stObj.getParametersId();
            int blobSize = stObj.getBlobSize();
            this.sendTileDeleted(layerName, gridSetId, blobFormat, paramsId, xyz[0], xyz[1], (int)xyz[2], blobSize);
        }
    }

    public void sendTileStored(TileObject stObj) {
        if (this.listeners.size() > 0) {
            long[] xyz = stObj.getXYZ();
            String layerName = stObj.getLayerName();
            String gridSetId = stObj.getGridSetId();
            String blobFormat = stObj.getBlobFormat();
            String paramsId = stObj.getParametersId();
            int blobSize = stObj.getBlobSize();
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).tileStored(layerName, gridSetId, blobFormat, paramsId, xyz[0], xyz[1], (int)xyz[2], blobSize);
            }
        }
    }

    public void sendTileUpdated(TileObject stObj, long oldSize) {
        if (this.listeners.size() > 0) {
            long[] xyz = stObj.getXYZ();
            String layerName = stObj.getLayerName();
            String gridSetId = stObj.getGridSetId();
            String blobFormat = stObj.getBlobFormat();
            String paramsId = stObj.getParametersId();
            int blobSize = stObj.getBlobSize();
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).tileUpdated(layerName, gridSetId, blobFormat, paramsId, xyz[0], xyz[1], (int)xyz[2], blobSize, oldSize);
            }
        }
    }
}

