/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.SRS;
import org.geowebcache.seed.GWCTask;

public class SeedRequest {
    private static Log log = LogFactory.getLog(SeedRequest.class);
    private String name = null;
    private BoundingBox bounds = null;
    private String gridSetId;
    private SRS srs;
    private Integer threadCount = null;
    private Integer zoomStart = null;
    private Integer zoomStop = null;
    private String format = null;
    private String type = null;
    private GWCTask.TYPE enumType = null;
    private Map<String, String> parameters = null;
    private Boolean filterUpdate = null;

    public SeedRequest() {
        System.out.println("New Empty SeedRequest");
    }

    public SeedRequest(String layerName, BoundingBox bounds, String gridSetId, int threadCount, int zoomStart, int zoomStop, String mimeFormat, GWCTask.TYPE type, Map<String, String> parameters) {
        this.name = layerName;
        this.bounds = bounds;
        this.gridSetId = gridSetId;
        this.threadCount = threadCount;
        this.zoomStart = zoomStart;
        this.zoomStop = zoomStop;
        this.format = mimeFormat;
        this.enumType = type;
        this.parameters = parameters;
    }

    public String getLayerName() {
        return this.name;
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public boolean getFilterUpdate() {
        if (this.filterUpdate != null) {
            return this.filterUpdate;
        }
        return false;
    }

    public String getGridSetId() {
        return this.gridSetId;
    }

    public String getMimeFormat() {
        return this.format;
    }

    public SRS getSRS() {
        return this.srs;
    }

    public Integer getZoomStart() {
        return this.zoomStart;
    }

    public Integer getZoomStop() {
        return this.zoomStop;
    }

    public Integer getThreadCount() {
        return this.threadCount;
    }

    public GWCTask.TYPE getType() {
        if (this.enumType == null) {
            if (this.type == null || this.type.equalsIgnoreCase("seed")) {
                return GWCTask.TYPE.SEED;
            }
            if (this.type.equalsIgnoreCase("reseed")) {
                return GWCTask.TYPE.RESEED;
            }
            if (this.type.equalsIgnoreCase("truncate")) {
                return GWCTask.TYPE.TRUNCATE;
            }
            log.warn((Object)("Unknown type \"" + this.type + "\", assuming seed"));
            return GWCTask.TYPE.SEED;
        }
        return this.enumType;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

