/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.TextMime;
import org.geowebcache.mime.XMLMime;

public class MimeType {
    protected String mimeType;
    protected String format;
    protected String fileExtension;
    protected String internalName;
    protected boolean supportsTiling;
    private static Log log = LogFactory.getLog(MimeType.class);

    protected MimeType(String mimeType, String fileExtension, String internalName, String format, boolean supportsTiling) {
        this.mimeType = mimeType;
        this.fileExtension = fileExtension;
        this.internalName = internalName;
        this.format = format;
        this.supportsTiling = supportsTiling;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFormat() {
        if (this.format != null) {
            return this.format;
        }
        return this.mimeType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public boolean supportsTiling() {
        return this.supportsTiling;
    }

    public boolean isVector() {
        return false;
    }

    public static MimeType createFromFormat(String formatStr) throws MimeException {
        MimeType mimeType = null;
        if (formatStr == null) {
            throw new MimeException("formatStr was not set");
        }
        mimeType = ImageMime.checkForFormat(formatStr);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = XMLMime.checkForFormat(formatStr);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = TextMime.checkForFormat(formatStr);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = ApplicationMime.checkForFormat(formatStr);
        if (mimeType != null) {
            return mimeType;
        }
        throw new MimeException("Unsupported format request: " + formatStr);
    }

    public static MimeType createFromExtension(String fileExtension) throws MimeException {
        MimeType mimeType = null;
        mimeType = ImageMime.checkForExtension(fileExtension);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = XMLMime.checkForExtension(fileExtension);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = TextMime.checkForExtension(fileExtension);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = ApplicationMime.checkForExtension(fileExtension);
        if (mimeType != null) {
            return mimeType;
        }
        log.debug((Object)("Unsupported MIME type: " + fileExtension + ", returning null"));
        return null;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            MimeType mimeObj = (MimeType)obj;
            if (this.mimeType.equalsIgnoreCase(mimeObj.mimeType)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.format.hashCode();
    }
}

