/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;

public class ApplicationMime
extends MimeType {
    protected boolean vector;
    public static final ApplicationMime bil16 = new ApplicationMime("application/bil16", "bil16", "bil16", "application/bil16", false);
    public static final ApplicationMime bil32 = new ApplicationMime("application/bil32", "bil32", "bil32", "application/bil32", false);
    public static final ApplicationMime json = new ApplicationMime("application/json", "json", "json", "application/json", false);
    public static final ApplicationMime topojson = new ApplicationMime("application/json", "topojson", "topojson", "application/json;type=topojson", true);
    public static final ApplicationMime geojson = new ApplicationMime("application/json", "geojson", "geojson", "application/json;type=geojson", true);
    public static final ApplicationMime mapboxVector = new ApplicationMime("application/x-protobuf", "pbf", "mapbox-vectortile", "application/x-protobuf;type=mapbox-vector", true);
    private static Set<ApplicationMime> ALL = ImmutableSet.of((Object)bil16, (Object)bil32, (Object)json, (Object)topojson, (Object)geojson, (Object)mapboxVector, (Object[])new ApplicationMime[0]);
    private static Map<String, ApplicationMime> BY_FORMAT = Maps.uniqueIndex(ALL, (Function)new Function<ApplicationMime, String>(){

        public String apply(ApplicationMime mimeType) {
            return mimeType.getFormat();
        }
    });
    private static Map<String, ApplicationMime> BY_EXTENSION = Maps.uniqueIndex(ALL, (Function)new Function<ApplicationMime, String>(){

        public String apply(ApplicationMime mimeType) {
            return mimeType.getFileExtension();
        }
    });

    private ApplicationMime(String mimeType, String fileExtension, String internalName, String format, boolean vector) {
        super(mimeType, fileExtension, internalName, format, false);
        this.vector = vector;
    }

    public ApplicationMime(String mimeType, String fileExtension, String internalName, String format) throws MimeException {
        super(mimeType, fileExtension, internalName, format, false);
    }

    protected static ApplicationMime checkForFormat(String formatStr) throws MimeException {
        ApplicationMime mimeType = BY_FORMAT.get(formatStr);
        return mimeType;
    }

    protected static ApplicationMime checkForExtension(String fileExtension) throws MimeException {
        ApplicationMime mimeType = BY_EXTENSION.get(fileExtension);
        return mimeType;
    }

    @Override
    public boolean isVector() {
        return this.vector;
    }
}

