/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.locks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.locks.MemoryLockProvider;
import org.geowebcache.storage.DefaultStorageFinder;

public class NIOLockProvider
implements LockProvider {
    public static Log LOGGER = LogFactory.getLog(NIOLockProvider.class);
    private String root;
    int waitBeforeRetry = 20;
    int maxLockAttempts = 120000 / this.waitBeforeRetry;
    MemoryLockProvider memoryProvider = new MemoryLockProvider();

    public NIOLockProvider(DefaultStorageFinder storageFinder) throws ConfigurationException {
        this.root = storageFinder.getDefaultPath();
    }

    public NIOLockProvider(String root) throws ConfigurationException {
        this.root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockProvider.Lock getLock(final String lockKey) throws GeoWebCacheException {
        LockProvider.Lock lock;
        File file = null;
        final LockProvider.Lock memoryLock = this.memoryProvider.getLock(lockKey);
        file = this.getFile(lockKey);
        FileOutputStream currFos = null;
        FileLock currLock = null;
        try {
            int count;
            for (count = 0; currLock == null && count < this.maxLockAttempts; ++count) {
                currFos = new FileOutputStream(file);
                try {
                    currLock = currFos.getChannel().lock();
                    continue;
                }
                catch (OverlappingFileLockException e) {
                    IOUtils.closeQuietly((OutputStream)currFos);
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                catch (IOException e) {
                    IOUtils.closeQuietly((OutputStream)currFos);
                    try {
                        Thread.sleep(20L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (count >= this.maxLockAttempts) {
                throw new GeoWebCacheException("Failed to get a lock on key " + lockKey + " after " + count + " attempts");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Lock " + lockKey + " acquired by thread " + Thread.currentThread().getId() + " on file " + file));
            }
            final FileOutputStream fos = currFos;
            final FileLock lock2 = currLock;
            currFos = null;
            currLock = null;
            final File lockFile = file;
            lock = new LockProvider.Lock(){
                boolean released;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void release() throws GeoWebCacheException {
                    if (this.released) {
                        return;
                    }
                    try {
                        this.released = true;
                        if (!lock2.isValid() && LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("Lock key " + lockKey + " for releasing lock is unkonwn, it means " + "this lock was never acquired, or was released twice. " + "Current thread is: " + Thread.currentThread().getId() + ". " + "Are you running two GWC instances in the same JVM using NIO locks? " + "This case is not supported and will generate exactly this error message"));
                            return;
                        }
                        try {
                            lock2.release();
                            IOUtils.closeQuietly((OutputStream)fos);
                            lockFile.delete();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("Lock " + lockKey + " released by thread " + Thread.currentThread().getId()));
                            }
                        }
                        catch (IOException e) {
                            throw new GeoWebCacheException("Failure while trying to release lock for key " + lockKey, e);
                        }
                    }
                    finally {
                        memoryLock.release();
                    }
                }
            };
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (currLock != null) {
                        currLock.release();
                    }
                    IOUtils.closeQuietly(currFos);
                    file.delete();
                }
                finally {
                    memoryLock.release();
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GeoWebCacheException("Failure while trying to get lock for key " + lockKey, e);
            }
        }
        try {
            if (currLock != null) {
                currLock.release();
            }
            IOUtils.closeQuietly((OutputStream)currFos);
            file.delete();
        }
        finally {
            memoryLock.release();
        }
        return lock;
    }

    private File getFile(String lockKey) {
        File locks = new File(this.root, "lockfiles");
        locks.mkdirs();
        String sha1 = DigestUtils.shaHex((String)lockKey);
        return new File(locks, sha1 + ".lck");
    }
}

