/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.locks;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.digest.DigestUtils;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.locks.LockProvider;

public class MemoryLockProvider
implements LockProvider {
    Lock[] locks;

    public MemoryLockProvider() {
        this(1024);
    }

    public MemoryLockProvider(int concurrency) {
        this.locks = new Lock[concurrency];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    @Override
    public LockProvider.Lock getLock(String lockKey) {
        final int idx = this.getIndex(lockKey);
        this.locks[idx].lock();
        return new LockProvider.Lock(){
            boolean released = false;

            @Override
            public void release() throws GeoWebCacheException {
                if (!this.released) {
                    this.released = true;
                    MemoryLockProvider.this.locks[idx].unlock();
                }
            }
        };
    }

    private int getIndex(String lockKey) {
        int idx = Math.abs(DigestUtils.shaHex((String)lockKey).hashCode() % this.locks.length);
        return idx;
    }
}

