/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.util.Map;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSMetaTile;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.util.ServletUtils;

public abstract class WMSSourceHelper {
    private int concurrency = 32;
    private int backendTimetout;

    protected abstract void makeRequest(TileResponseReceiver var1, WMSLayer var2, Map<String, String> var3, String var4, Resource var5) throws GeoWebCacheException;

    public void makeRequest(WMSMetaTile metaTile, Resource target) throws GeoWebCacheException {
        Map<String, String> wmsParams = metaTile.getWMSParams();
        WMSLayer layer = metaTile.getLayer();
        String format = metaTile.getRequestFormat().getFormat();
        this.makeRequest(metaTile, layer, wmsParams, format, target);
    }

    public void makeRequest(ConveyorTile tile, Resource target) throws GeoWebCacheException {
        WMSLayer layer = (WMSLayer)tile.getLayer();
        GridSubset gridSubset = layer.getGridSubset(tile.getGridSetId());
        Map<String, String> wmsParams = layer.getWMSRequestTemplate(tile.getMimeType(), WMSLayer.RequestType.MAP);
        wmsParams.put("FORMAT", tile.getMimeType().getMimeType());
        wmsParams.put("SRS", layer.backendSRSOverride(gridSubset.getSRS()));
        wmsParams.put("HEIGHT", String.valueOf(gridSubset.getTileHeight()));
        wmsParams.put("WIDTH", String.valueOf(gridSubset.getTileWidth()));
        BoundingBox bbox = gridSubset.boundsFromIndex(tile.getTileIndex());
        wmsParams.put("BBOX", bbox.toString());
        Map<String, String> fullParameters = tile.getFullParameters();
        if (fullParameters.isEmpty()) {
            fullParameters = layer.getDefaultParameterFilters();
        }
        wmsParams.putAll(fullParameters);
        if (tile.getMimeType() == XMLMime.kml) {
            wmsParams.put("format_options", "mode:superoverlay;overlaymode:auto");
        }
        String mimeType = tile.getMimeType().getMimeType();
        this.makeRequest(tile, layer, wmsParams, mimeType, target);
    }

    public Resource makeFeatureInfoRequest(ConveyorTile tile, BoundingBox bbox, int height, int width, int x, int y) throws GeoWebCacheException {
        WMSLayer layer = (WMSLayer)tile.getLayer();
        GridSubset gridSubset = tile.getGridSubset();
        Map<String, String> wmsParams = layer.getWMSRequestTemplate(tile.getMimeType(), WMSLayer.RequestType.FEATUREINFO);
        wmsParams.put("INFO_FORMAT", tile.getMimeType().getFormat());
        wmsParams.put("FORMAT", layer.getDefaultMimeType().getMimeType());
        wmsParams.put("SRS", layer.backendSRSOverride(gridSubset.getSRS()));
        wmsParams.put("HEIGHT", String.valueOf(height));
        wmsParams.put("WIDTH", String.valueOf(width));
        wmsParams.put("BBOX", bbox.toString());
        Map<String, String> fullParameters = tile.getFullParameters();
        if (fullParameters.isEmpty()) {
            fullParameters = layer.getDefaultParameterFilters();
        }
        wmsParams.putAll(fullParameters);
        wmsParams.put("X", String.valueOf(x));
        wmsParams.put("Y", String.valueOf(y));
        Map<String, String> values = ServletUtils.selectedStringsFromMap(tile.servletReq.getParameterMap(), tile.servletReq.getCharacterEncoding(), "feature_count");
        String featureCount = values.get("feature_count");
        if (featureCount != null) {
            wmsParams.put("FEATURE_COUNT", featureCount);
        }
        String mimeType = tile.getMimeType().getMimeType();
        ByteArrayResource target = new ByteArrayResource(2048);
        this.makeRequest(tile, layer, wmsParams, mimeType, target);
        return target;
    }

    protected boolean mimeStringCheck(String requestMime, String responseMime) {
        if (responseMime.equalsIgnoreCase(requestMime)) {
            return true;
        }
        if (responseMime.startsWith(requestMime)) {
            return true;
        }
        return requestMime.startsWith("image/png") && responseMime.startsWith("image/png");
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public void setBackendTimeout(int backendTimeout) {
        this.backendTimetout = backendTimeout;
    }

    public int getBackendTimeout() {
        return this.backendTimetout;
    }
}

