/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.AbstractTileLayer;
import org.geowebcache.layer.ExpirationRule;
import org.geowebcache.layer.ProxyLayer;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.meta.MetadataURL;
import org.geowebcache.layer.wms.WMSHttpHelper;
import org.geowebcache.layer.wms.WMSMetaTile;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.XMLMime;

public class WMSLayer
extends AbstractTileLayer
implements ProxyLayer {
    private static Log log = LogFactory.getLog(WMSLayer.class);
    private String[] wmsUrl;
    private String wmsLayers;
    private String wmsQueryLayers;
    protected String wmsStyles;
    protected Integer gutter;
    private String errorMime;
    private String wmsVersion;
    private String httpUsername;
    private String httpPassword;
    private String proxyUrl;
    private Boolean tiled;
    private Boolean transparent;
    private String bgColor;
    private String palette;
    private String vendorParameters;
    private String cachePrefix;
    private Integer concurrency;
    private transient int curWmsURL;
    private transient WMSSourceHelper sourceHelper;
    protected transient String sphericalMercatorOverride;
    private transient LockProvider lockProvider;

    WMSLayer() {
    }

    @Deprecated
    public WMSLayer(String layerName, String[] wmsURL, String wmsStyles, String wmsLayers, List<String> mimeFormats, Map<String, GridSubset> subSets, List<ParameterFilter> parameterFilters, int[] metaWidthHeight, String vendorParams, boolean queryable) {
        this(layerName, wmsURL, wmsStyles, wmsLayers, mimeFormats, subSets, parameterFilters, metaWidthHeight, vendorParams, queryable, null);
    }

    public WMSLayer(String layerName, String[] wmsURL, String wmsStyles, String wmsLayers, List<String> mimeFormats, Map<String, GridSubset> subSets, List<ParameterFilter> parameterFilters, int[] metaWidthHeight, String vendorParams, boolean queryable, String wmsQueryLayers) {
        this.name = layerName;
        this.wmsUrl = wmsURL;
        this.wmsLayers = wmsLayers;
        this.wmsStyles = wmsStyles;
        this.mimeFormats = mimeFormats == null ? null : new ArrayList<String>(mimeFormats);
        this.subSets = subSets;
        this.gridSubsets = new ArrayList();
        if (subSets != null) {
            for (GridSubset subset : subSets.values()) {
                this.gridSubsets.add(new XMLGridSubset(subset));
            }
        }
        this.parameterFilters = parameterFilters == null ? null : new ArrayList<ParameterFilter>(parameterFilters);
        this.metaWidthHeight = metaWidthHeight;
        this.vendorParameters = vendorParams;
        this.transparent = true;
        this.queryable = queryable;
        this.wmsQueryLayers = wmsQueryLayers;
    }

    @Override
    protected WMSLayer readResolve() {
        super.readResolve();
        return this;
    }

    @Override
    protected boolean initializeInternal(GridSetBroker gridSetBroker) {
        if (null == this.enabled) {
            this.enabled = Boolean.TRUE;
        }
        if (null == this.sourceHelper) {
            log.warn((Object)(this.name + " is configured without a source, which is a bug unless you're running tests that don't care."));
        }
        this.curWmsURL = 0;
        if (this.backendTimeout == null) {
            this.backendTimeout = 120;
        }
        if (this.metaWidthHeight == null || this.metaWidthHeight.length != 2) {
            this.metaWidthHeight = new int[2];
            this.metaWidthHeight[0] = 3;
            this.metaWidthHeight[1] = 3;
        }
        if (this.concurrency == null) {
            this.concurrency = 32;
        }
        if (this.sourceHelper instanceof WMSHttpHelper) {
            for (int i = 0; i < this.wmsUrl.length; ++i) {
                String url = this.wmsUrl[i];
                if (url.contains("?")) continue;
                this.wmsUrl[i] = url + "?";
            }
        }
        if (this.gutter == null) {
            this.gutter = 0;
        }
        if (this.requestFilters != null) {
            Iterator iter = this.requestFilters.iterator();
            while (iter.hasNext()) {
                try {
                    ((RequestFilter)iter.next()).initialize(this);
                }
                catch (GeoWebCacheException e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
        return true;
    }

    @Override
    public Resource getFeatureInfo(ConveyorTile convTile, BoundingBox bbox, int height, int width, int x, int y) throws GeoWebCacheException {
        return this.sourceHelper.makeFeatureInfoRequest(convTile, bbox, height, width, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConveyorTile getTile(ConveyorTile tile) throws GeoWebCacheException, IOException, OutsideCoverageException {
        ConveyorTile returnTile;
        MimeType mime = tile.getMimeType();
        if (mime == null) {
            mime = (MimeType)this.formats.get(0);
        }
        if (!this.formats.contains(mime)) {
            throw new GeoWebCacheException(mime.getFormat() + " is not a supported format for " + this.name);
        }
        String tileGridSetId = tile.getGridSetId();
        long[] gridLoc = tile.getTileIndex();
        GridSubset gridSubset = this.getGridSubset(tileGridSetId);
        gridSubset.checkCoverage(gridLoc);
        tile.setMetaTileCacheOnly(!gridSubset.shouldCacheAtZoom(gridLoc[2]));
        try {
            returnTile = this.tryCacheFetch(tile) ? this.finalizeTile(tile) : (mime.supportsTiling() ? this.getMetatilingReponse(tile, true) : this.getNonMetatilingReponse(tile, true));
        }
        finally {
            this.cleanUpThreadLocals();
        }
        this.sendTileRequestedEvent(returnTile);
        return returnTile;
    }

    @Override
    public void seedTile(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException, IOException {
        GridSubset gridSubset = this.getGridSubset(tile.getGridSetId());
        if (gridSubset.shouldCacheAtZoom(tile.getTileIndex()[2])) {
            if (tile.getMimeType().supportsTiling() && (this.metaWidthHeight[0] > 1 || this.metaWidthHeight[1] > 1)) {
                this.getMetatilingReponse(tile, tryCache);
            } else {
                this.getNonMetatilingReponse(tile, tryCache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConveyorTile getMetatilingReponse(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException {
        long[] gridLoc = tile.getTileIndex();
        GridSubset gridSubset = (GridSubset)this.subSets.get(tile.getGridSetId());
        MimeType mimeType = tile.getMimeType();
        Map<String, String> fullParameters = tile.getFullParameters();
        if (fullParameters.isEmpty()) {
            fullParameters = this.getDefaultParameterFilters();
        }
        WMSMetaTile metaTile = new WMSMetaTile(this, gridSubset, mimeType, this.getFormatModifier(tile.getMimeType()), gridLoc, this.metaWidthHeight[0], this.metaWidthHeight[1], fullParameters);
        if (this.saveExpirationHeaders) {
            metaTile.setExpiresHeader(-4L);
        }
        String metaKey = this.buildLockKey(tile, metaTile);
        LockProvider.Lock lock = null;
        try {
            lock = this.lockProvider.getLock(metaKey);
            if (tryCache && this.tryCacheFetch(tile)) {
                ConveyorTile conveyorTile = this.finalizeTile(tile);
                return conveyorTile;
            }
            tile.setCacheResult(Conveyor.CacheResult.MISS);
            ByteArrayResource buffer = this.getImageBuffer(WMS_BUFFER);
            if (this.saveExpirationHeaders) {
                metaTile.setExpiresHeader(-4L);
            }
            long requestTime = System.currentTimeMillis();
            this.sourceHelper.makeRequest(metaTile, (Resource)buffer);
            if (metaTile.getError()) {
                throw new GeoWebCacheException("Empty metatile, error message: " + metaTile.getErrorMessage());
            }
            if (this.saveExpirationHeaders) {
                this.saveExpirationInformation((int)(tile.getExpiresHeader() / 1000L));
            }
            metaTile.setImageBytes(buffer);
            this.saveTiles(metaTile, tile, requestTime);
        }
        finally {
            if (lock != null) {
                lock.release();
            }
            metaTile.dispose();
        }
        return this.finalizeTile(tile);
    }

    private String buildLockKey(ConveyorTile tile, WMSMetaTile metaTile) {
        long[] tileIndex;
        StringBuilder metaKey = new StringBuilder();
        if (metaTile != null) {
            tileIndex = metaTile.getMetaGridPos();
            metaKey.append("meta_");
        } else {
            tileIndex = tile.getTileIndex();
            metaKey.append("tile_");
        }
        long x = tileIndex[0];
        long y = tileIndex[1];
        long z = tileIndex[2];
        metaKey.append(tile.getLayerId());
        metaKey.append("_").append(tile.getGridSetId());
        metaKey.append("_").append(x).append("_").append(y).append("_").append(z);
        if (tile.getParametersId() != null) {
            metaKey.append("_").append(tile.getParametersId());
        }
        metaKey.append(".").append(tile.getMimeType().getFileExtension());
        return metaKey.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConveyorTile getNonMetatilingReponse(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException {
        long[] gridLoc = tile.getTileIndex();
        String lockKey = this.buildLockKey(tile, null);
        LockProvider.Lock lock = null;
        try {
            lock = this.lockProvider.getLock(lockKey);
            if (tryCache && this.tryCacheFetch(tile)) {
                ConveyorTile conveyorTile = tile;
                return conveyorTile;
            }
            if (this.saveExpirationHeaders) {
                tile.setExpiresHeader(-4L);
            }
            if ((tile = this.doNonMetatilingRequest(tile)).getStatus() > 299 || this.getExpireCache((int)gridLoc[2]) != -1) {
                tile.persist();
            }
            if (this.saveExpirationHeaders) {
                this.saveExpirationInformation((int)(tile.getExpiresHeader() / 1000L));
            }
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        return this.finalizeTile(tile);
    }

    public boolean tryCacheFetch(ConveyorTile tile) {
        int expireCache = this.getExpireCache((int)tile.getTileIndex()[2]);
        if (expireCache != -1) {
            try {
                return tile.retrieve((long)expireCache * 1000L);
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
                tile.setErrorMsg(gwce.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public ConveyorTile doNonMetatilingRequest(ConveyorTile tile) throws GeoWebCacheException {
        tile.setTileLayer(this);
        ByteArrayResource buffer = this.getImageBuffer(WMS_BUFFER);
        this.sourceHelper.makeRequest(tile, (Resource)buffer);
        if (tile.getError() || buffer.getSize() == 0L) {
            throw new GeoWebCacheException("Empty tile, error message: " + tile.getErrorMessage());
        }
        tile.setBlob(buffer);
        return tile;
    }

    private ConveyorTile finalizeTile(ConveyorTile tile) {
        if (tile.getStatus() == 0 && !tile.getError()) {
            tile.setStatus(200);
        }
        if (tile.servletResp != null) {
            this.setExpirationHeader(tile.servletResp, (int)tile.getTileIndex()[2]);
        }
        return tile;
    }

    protected void saveExpirationInformation(int backendExpire) {
        this.saveExpirationHeaders = false;
        try {
            if (this.getExpireCache(0) == -4) {
                if (backendExpire == -1) {
                    this.expireCacheList.set(0, new ExpirationRule(0, 7200));
                    log.error((Object)"Layer profile wants MaxAge from backend, but backend does not provide this. Setting to 7200 seconds.");
                } else {
                    this.expireCacheList.set(backendExpire, new ExpirationRule(0, 7200));
                }
                log.trace((Object)("Setting expireCache to: " + this.expireCache));
            }
            if (this.getExpireCache(0) == -4) {
                if (backendExpire == -1) {
                    this.expireClientsList.set(0, new ExpirationRule(0, 7200));
                    log.error((Object)"Layer profile wants MaxAge from backend, but backend does not provide this. Setting to 7200 seconds.");
                } else {
                    this.expireClientsList.set(0, new ExpirationRule(0, backendExpire));
                    log.trace((Object)("Setting expireClients to: " + this.expireClients));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, String> getWMSRequestTemplate(MimeType responseFormat, RequestType reqType) {
        HashMap<String, String> params = new HashMap<String, String>();
        FormatModifier mod = this.getFormatModifier(responseFormat);
        params.put("SERVICE", "WMS");
        String request = reqType == RequestType.MAP ? "GetMap" : "GetFeatureInfo";
        params.put("REQUEST", request);
        String version = this.wmsVersion;
        if (this.wmsVersion == null) {
            version = "1.1.1";
        }
        params.put("VERSION", version);
        String layers = this.wmsLayers != null && this.wmsLayers.length() != 0 ? this.wmsLayers : this.getName();
        params.put("LAYERS", layers);
        if (reqType == RequestType.FEATUREINFO) {
            params.put("QUERY_LAYERS", this.wmsQueryLayers != null ? this.wmsQueryLayers : layers);
        }
        String exceptions = this.errorMime != null ? this.errorMime : XMLMime.ogcxml.getMimeType();
        params.put("EXCEPTIONS", exceptions);
        String styles = "";
        if (this.wmsStyles != null && this.wmsStyles.length() != 0) {
            styles = this.wmsStyles;
        }
        params.put("STYLES", styles);
        if (reqType == RequestType.MAP) {
            Boolean tmpTransparent = this.transparent;
            if (mod != null && mod.getTransparent() != null) {
                tmpTransparent = mod.getTransparent();
            }
            if (tmpTransparent == null || tmpTransparent.booleanValue()) {
                params.put("TRANSPARENT", "TRUE");
            } else {
                params.put("TRANSPARENT", "FALSE");
            }
            String tmpBgColor = this.bgColor;
            if (mod != null && mod.getBgColor() != null) {
                tmpBgColor = mod.getBgColor();
            }
            if (tmpBgColor != null && tmpBgColor.length() != 0) {
                params.put("BGCOLOR", tmpBgColor);
            }
            String tmpPalette = this.palette;
            if (mod != null && mod.getPalette() != null) {
                tmpPalette = mod.getPalette();
            }
            if (tmpPalette != null && tmpPalette.length() != 0) {
                params.put("PALETTE", tmpPalette);
            }
        }
        if (this.vendorParameters != null && this.vendorParameters.length() != 0) {
            String[] vparams;
            for (String vp : vparams = this.vendorParameters.split("&")) {
                if (vp.length() <= 0) continue;
                String[] split = vp.split("=");
                String key = split[0];
                String val = split[1];
                if (key.length() <= 0) continue;
                params.put(key, val);
            }
        }
        return params;
    }

    protected String nextWmsURL() {
        this.curWmsURL = (this.curWmsURL + 1) % this.wmsUrl.length;
        return this.wmsUrl[this.curWmsURL];
    }

    public long[][] getZoomedInGridLoc(String gridSetId, long[] gridLoc) throws GeoWebCacheException {
        return null;
    }

    public void setErrorMime(String errormime) {
        this.errorMime = errormime;
    }

    public void addMetaWidthHeight(int w, int h) {
        this.metaWidthHeight[0] = w;
        this.metaWidthHeight[1] = h;
    }

    public void setWMSurl(String[] wmsurl) {
        this.wmsUrl = wmsurl;
    }

    public String[] getWMSurl() {
        return this.wmsUrl;
    }

    public String getWmsLayers() {
        return this.wmsLayers;
    }

    public String getWmsQueryLayers() {
        return this.wmsQueryLayers;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public String getHttpUsername() {
        return this.httpUsername;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setSourceHelper(WMSSourceHelper source) {
        log.debug((Object)("Setting sourceHelper on " + this.name));
        this.sourceHelper = source;
        if (this.concurrency != null) {
            this.sourceHelper.setConcurrency(this.concurrency);
        } else {
            this.sourceHelper.setConcurrency(32);
        }
        if (this.backendTimeout != null) {
            this.sourceHelper.setBackendTimeout(this.backendTimeout);
        } else {
            this.sourceHelper.setBackendTimeout(120);
        }
    }

    public WMSSourceHelper getSourceHelper() {
        return this.sourceHelper;
    }

    public void setVersion(String version) {
        this.wmsVersion = version;
    }

    public void setTiled(boolean tiled) {
        this.tiled = tiled;
    }

    public boolean getTransparent() {
        return this.transparent == null || this.transparent != false;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public int[] getBackgroundColor() {
        if (this.bgColor == null || this.transparent != null && this.transparent.booleanValue()) {
            return null;
        }
        int[] ret = new int[]{Integer.parseInt(this.bgColor.substring(2, 4), 16), Integer.parseInt(this.bgColor.substring(4, 6), 16), Integer.parseInt(this.bgColor.substring(6, 8), 16)};
        return ret;
    }

    @Override
    public ConveyorTile getNoncachedTile(ConveyorTile tile) throws GeoWebCacheException {
        ByteArrayResource buffer = new ByteArrayResource(2048);
        this.sourceHelper.makeRequest(tile, (Resource)buffer);
        tile.setBlob(buffer);
        return tile;
    }

    public String backendSRSOverride(SRS srs) {
        if (this.sphericalMercatorOverride != null && srs.equals(SRS.getEPSG3857())) {
            return this.sphericalMercatorOverride;
        }
        return srs.toString();
    }

    public void cleanUpThreadLocals() {
        WMS_BUFFER.remove();
        WMS_BUFFER2.remove();
    }

    public void setMetaInformation(LayerMetaInformation layerMetaInfo) {
        this.metaInformation = layerMetaInfo;
    }

    public void setMetadataURLs(List<MetadataURL> metadataURLs) {
        this.metadataURLs = metadataURLs;
    }

    @Override
    public String getStyles() {
        return this.wmsStyles;
    }

    public void setLockProvider(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proxyRequest(ConveyorTile tile) throws GeoWebCacheException {
        block9: {
            InputStream is;
            block8: {
                String queryStr = tile.servletReq.getQueryString();
                String serverStr = this.getWMSurl()[0];
                GetMethod getMethod = null;
                is = null;
                try {
                    URL url = serverStr.contains("?") ? new URL(serverStr + "&" + queryStr) : new URL(serverStr + queryStr);
                    WMSSourceHelper helper = this.getSourceHelper();
                    if (!(helper instanceof WMSHttpHelper)) {
                        throw new GeoWebCacheException("Can only proxy if WMS Layer is backed by an HTTP backend");
                    }
                    getMethod = ((WMSHttpHelper)helper).executeRequest(url, null, this.getBackendTimeout());
                    is = getMethod.getResponseBodyAsStream();
                    HttpServletResponse response = tile.servletResp;
                    response.setCharacterEncoding(getMethod.getResponseCharSet());
                    response.setContentType(getMethod.getResponseHeader("Content-Type").getValue());
                    int read = 0;
                    byte[] data = new byte[1024];
                    while (read > -1) {
                        read = is.read(data);
                        if (read <= -1) continue;
                        response.getOutputStream().write(data, 0, read);
                    }
                    if (getMethod == null) break block8;
                }
                catch (IOException ioe) {
                    tile.servletResp.setStatus(500);
                    log.error((Object)ioe.getMessage());
                    break block9;
                }
                finally {
                    if (getMethod != null) {
                        getMethod.releaseConnection();
                    }
                    IOUtils.closeQuietly(is);
                }
                getMethod.releaseConnection();
            }
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static enum RequestType {
        MAP,
        FEATUREINFO;

    }
}

