/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.mime.ErrorMime;
import org.geowebcache.service.ServiceException;
import org.geowebcache.util.HttpClientBuilder;
import org.geowebcache.util.ServletUtils;
import org.springframework.util.Assert;

public class WMSHttpHelper
extends WMSSourceHelper {
    private static Log log = LogFactory.getLog(WMSHttpHelper.class);
    private final URL proxyUrl;
    private final String httpUsername;
    private final String httpPassword;
    private volatile HttpClient client;
    private boolean doAuthentication;

    public WMSHttpHelper() {
        this(null, null, null);
    }

    public WMSHttpHelper(String httpUsername, String httpPassword, URL proxyUrl) {
        this.httpUsername = httpUsername;
        this.httpPassword = httpPassword;
        this.proxyUrl = proxyUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpClient getHttpClient() {
        if (this.client == null) {
            WMSHttpHelper wMSHttpHelper = this;
            synchronized (wMSHttpHelper) {
                if (this.client != null) {
                    return this.client;
                }
                HttpClientBuilder builder = new HttpClientBuilder(null, this.getBackendTimeout(), this.httpUsername, this.httpPassword, this.proxyUrl, this.getConcurrency());
                this.doAuthentication = builder.isDoAuthentication();
                this.client = builder.buildClient();
            }
        }
        return this.client;
    }

    @Override
    protected void makeRequest(TileResponseReceiver tileRespRecv, WMSLayer layer, Map<String, String> wmsParams, String expectedMimeType, Resource target) throws GeoWebCacheException {
        int backendTries;
        Assert.notNull((Object)target, (String)"Target resource can't be null");
        Assert.isTrue((target.getSize() == 0L ? 1 : 0) != 0, (String)"Target resource is not empty");
        URL wmsBackendUrl = null;
        Integer backendTimeout = layer.getBackendTimeout();
        GeoWebCacheException fetchException = null;
        for (backendTries = 0; target.getSize() == 0L && backendTries < layer.getWMSurl().length; ++backendTries) {
            String requestUrl = layer.nextWmsURL();
            try {
                wmsBackendUrl = new URL(requestUrl);
            }
            catch (MalformedURLException maue) {
                throw new GeoWebCacheException("Malformed URL: " + requestUrl + " " + maue.getMessage());
            }
            try {
                this.connectAndCheckHeaders(tileRespRecv, wmsBackendUrl, wmsParams, expectedMimeType, backendTimeout, target);
                continue;
            }
            catch (GeoWebCacheException e) {
                fetchException = e;
            }
        }
        if (target.getSize() == 0L) {
            String msg = "All backends (" + backendTries + ") failed.";
            if (fetchException != null) {
                msg = msg + " Reason: " + fetchException.getMessage() + ". ";
            }
            msg = msg + " Last request: '" + wmsBackendUrl.toString() + "'. " + (tileRespRecv.getErrorMessage() == null ? "" : tileRespRecv.getErrorMessage());
            tileRespRecv.setError();
            tileRespRecv.setErrorMessage(msg);
            throw new GeoWebCacheException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndCheckHeaders(TileResponseReceiver tileRespRecv, URL wmsBackendUrl, Map<String, String> wmsParams, String requestMime, Integer backendTimeout, Resource target) throws GeoWebCacheException {
        block32: {
            GetMethod getMethod = null;
            try {
                String expireValue;
                long expire;
                int responseLength;
                int responseCode;
                try {
                    getMethod = this.executeRequest(wmsBackendUrl, wmsParams, backendTimeout);
                    responseCode = getMethod.getStatusCode();
                    responseLength = (int)getMethod.getResponseContentLength();
                }
                catch (IOException ce) {
                    if (log.isDebugEnabled()) {
                        String message = "Error forwarding request " + wmsBackendUrl.toString();
                        log.debug((Object)message, (Throwable)ce);
                    }
                    throw new GeoWebCacheException(ce);
                }
                tileRespRecv.setStatus(responseCode);
                if (responseCode != 200 && responseCode != 204) {
                    tileRespRecv.setError();
                    throw new ServiceException("Unexpected response code from backend: " + responseCode + " for " + wmsBackendUrl.toString());
                }
                String responseMime = getMethod.getResponseHeader("Content-Type").getValue();
                if (responseCode != 204 && responseMime != null && !this.mimeStringCheck(requestMime, responseMime)) {
                    InputStream stream;
                    String message = null;
                    if (responseMime.equalsIgnoreCase(ErrorMime.vnd_ogc_se_inimage.getFormat())) {
                        stream = null;
                        try {
                            stream = getMethod.getResponseBodyAsStream();
                            byte[] error = IOUtils.toByteArray((InputStream)stream);
                            message = new String(error);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)stream);
                        }
                    } else if (responseMime != null && responseMime.toLowerCase().startsWith("application/vnd.ogc.se_xml")) {
                        stream = null;
                        try {
                            stream = getMethod.getResponseBodyAsStream();
                            message = IOUtils.toString((InputStream)stream);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)stream);
                        }
                    }
                    String msg = "MimeType mismatch, expected " + requestMime + " but got " + responseMime + " from " + wmsBackendUrl.toString() + (message == null ? "" : ":\n" + message);
                    tileRespRecv.setError();
                    tileRespRecv.setErrorMessage(msg);
                    log.warn((Object)msg);
                }
                if (tileRespRecv.getExpiresHeader() == -4L && (expire = ServletUtils.parseExpiresHeader(expireValue = getMethod.getResponseHeader("Expires").getValue())) != -1L) {
                    tileRespRecv.setExpiresHeader(expire / 1000L);
                }
                if (responseCode == 204) break block32;
                try {
                    int readAccu;
                    InputStream inStream = getMethod.getResponseBodyAsStream();
                    if (inStream == null) {
                        String uri = getMethod.getURI().getURI();
                        log.error((Object)("No response for " + getMethod.getName() + " " + uri));
                    } else {
                        try (ReadableByteChannel channel = Channels.newChannel(inStream);){
                            target.transferFrom(channel);
                        }
                    }
                    if (responseLength > 0 && (readAccu = (int)target.getSize()) != responseLength) {
                        tileRespRecv.setError();
                        throw new GeoWebCacheException("Responseheader advertised " + responseLength + " bytes, but only received " + readAccu + " from " + wmsBackendUrl.toString());
                    }
                }
                catch (IOException ioe) {
                    tileRespRecv.setError();
                    log.error((Object)("Caught IO exception, " + wmsBackendUrl.toString() + " " + ioe.getMessage()));
                }
            }
            finally {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
    }

    public GetMethod executeRequest(URL url, Map<String, String> queryParams, Integer backendTimeout) throws HttpException, IOException {
        HttpClient httpClient = this.getHttpClient();
        GetMethod getMethod = new GetMethod(url.toString());
        if (queryParams != null && queryParams.size() > 0) {
            NameValuePair[] params = new NameValuePair[queryParams.size()];
            int i = 0;
            for (Map.Entry<String, String> e : queryParams.entrySet()) {
                params[i] = new NameValuePair(e.getKey(), e.getValue());
                ++i;
            }
            getMethod.setQueryString(params);
        }
        getMethod.setDoAuthentication(this.doAuthentication);
        if (log.isDebugEnabled()) {
            log.trace((Object)getMethod.getURI().getURI());
        }
        httpClient.executeMethod((HttpMethod)getMethod);
        return getMethod;
    }
}

