/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLGridSet;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.util.CompositeIterable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;

public class TileLayerDispatcher
implements DisposableBean {
    private static Log log = LogFactory.getLog(TileLayerDispatcher.class);
    private List<Configuration> configs;
    private GridSetBroker gridSetBroker;
    private ServiceInformation serviceInformation;

    public TileLayerDispatcher(GridSetBroker gridSetBroker, List<Configuration> configs) {
        this.gridSetBroker = gridSetBroker;
        this.configs = configs == null ? new ArrayList() : configs;
        this.initialize();
    }

    public TileLayerDispatcher(GridSetBroker gridSetBroker) {
        this.gridSetBroker = gridSetBroker;
        this.reInit();
    }

    public void addConfiguration(Configuration config) {
        this.initialize(config);
        ArrayList<Configuration> newList = new ArrayList<Configuration>(this.configs);
        newList.add(config);
        this.configs = newList;
    }

    public boolean layerExists(String layerName) {
        for (int i = 0; i < this.configs.size(); ++i) {
            Configuration configuration = this.configs.get(i);
            TileLayer layer = configuration.getTileLayer(layerName);
            if (layer == null) continue;
            return true;
        }
        return false;
    }

    public TileLayer getTileLayer(String layerName) throws GeoWebCacheException {
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName is null");
        for (int i = 0; i < this.configs.size(); ++i) {
            Configuration configuration = this.configs.get(i);
            TileLayer layer = configuration.getTileLayer(layerName);
            if (layer == null) continue;
            return layer;
        }
        throw new GeoWebCacheException("Thread " + Thread.currentThread().getId() + " Unknown layer " + layerName + ". Check the logfiles," + " it may not have loaded properly.");
    }

    public void reInit() {
        List<Configuration> extensions = GeoWebCacheExtensions.extensions(Configuration.class);
        this.configs = new ArrayList<Configuration>(extensions);
        this.initialize();
    }

    public int getLayerCount() {
        int count = 0;
        for (int i = 0; i < this.configs.size(); ++i) {
            Configuration configuration = this.configs.get(i);
            count += configuration.getTileLayerCount();
        }
        return count;
    }

    public Set<String> getLayerNames() {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this.configs.size(); ++i) {
            Configuration configuration = this.configs.get(i);
            names.addAll(configuration.getTileLayerNames());
        }
        return names;
    }

    public Iterable<TileLayer> getLayerList() {
        ArrayList perConfigLayers = new ArrayList(this.configs.size());
        for (Configuration config : this.configs) {
            perConfigLayers.add(config.getLayers());
        }
        return new CompositeIterable<TileLayer>(perConfigLayers);
    }

    private void initialize() {
        log.debug((Object)"Thread initLayers(), initializing");
        for (Configuration config : this.configs) {
            this.initialize(config);
        }
    }

    private int initialize(Configuration config) {
        int layerCount;
        if (config == null) {
            throw new IllegalStateException("TileLayerDispatcher got a null GWC configuration object");
        }
        String configIdent = null;
        try {
            configIdent = config.getIdentifier();
        }
        catch (Exception gwce) {
            log.error((Object)("Error obtaining identify from Configuration " + config), (Throwable)gwce);
            return 0;
        }
        if (configIdent == null) {
            log.warn((Object)("Got a GWC configuration with no identity, ignoring it:" + config));
            return 0;
        }
        try {
            layerCount = config.initialize(this.gridSetBroker);
        }
        catch (GeoWebCacheException gwce) {
            log.error((Object)("Failed to add layers from " + configIdent), (Throwable)gwce);
            return 0;
        }
        if (layerCount <= 0) {
            log.info((Object)("Configuration " + config.getIdentifier() + " contained no layers."));
        }
        if (this.serviceInformation == null) {
            log.debug((Object)"Reading service information.");
            this.serviceInformation = config.getServiceInformation();
        }
        return layerCount;
    }

    public ServiceInformation getServiceInformation() {
        return this.serviceInformation;
    }

    public void destroy() throws Exception {
    }

    public synchronized Configuration removeLayer(String layerName) throws IllegalArgumentException {
        for (Configuration config : this.configs) {
            if (!config.removeLayer(layerName)) continue;
            return config;
        }
        return null;
    }

    public synchronized Configuration addLayer(TileLayer tl) throws IllegalArgumentException {
        for (Configuration c : this.configs) {
            if (!c.canSave(tl)) continue;
            c.addLayer(tl);
            return c;
        }
        throw new IllegalArgumentException("No configuration found capable of saving " + tl);
    }

    public synchronized Configuration modify(TileLayer tl) throws IllegalArgumentException {
        Configuration config = this.getConfiguration(tl);
        config.modifyLayer(tl);
        return config;
    }

    public Configuration getConfiguration(TileLayer tl) throws IllegalArgumentException {
        Assert.notNull((Object)tl, (String)"layer is null");
        return this.getConfiguration(tl.getId());
    }

    public Configuration getConfiguration(String tileLayerId) throws IllegalArgumentException {
        Assert.notNull((Object)tileLayerId, (String)"tileLayerId is null");
        for (Configuration c : this.configs) {
            if (!c.containsLayer(tileLayerId)) continue;
            return c;
        }
        throw new IllegalArgumentException("No configuration found containing layer " + tileLayerId);
    }

    public synchronized Configuration removeGridset(String gridSetName) throws IllegalStateException, IOException {
        GridSet gridSet = this.gridSetBroker.get(gridSetName);
        if (gridSet == null) {
            return null;
        }
        ArrayList<String> refereningLayers = new ArrayList<String>();
        for (TileLayer layer : this.getLayerList()) {
            GridSubset gridSubset = layer.getGridSubset(gridSetName);
            if (gridSubset == null) continue;
            refereningLayers.add(layer.getName());
        }
        if (refereningLayers.size() > 0) {
            throw new IllegalStateException("There are TileLayers referencing gridset '" + gridSetName + "': " + ((Object)refereningLayers).toString());
        }
        XMLConfiguration persistingConfig = this.getXmlConfiguration();
        GridSet removed = this.gridSetBroker.remove(gridSetName);
        Assert.notNull((Object)(removed != null ? 1 : 0));
        Assert.notNull((Object)persistingConfig.removeGridset(gridSetName));
        return persistingConfig;
    }

    public synchronized void addGridSet(GridSet gridSet) throws IllegalArgumentException, IOException {
        if (null != this.gridSetBroker.get(gridSet.getName())) {
            throw new IllegalArgumentException("GridSet " + gridSet.getName() + " already exists");
        }
        this.saveGridSet(gridSet);
    }

    private void saveGridSet(GridSet gridSet) throws IOException {
        XMLConfiguration persistingConfig = this.getXmlConfiguration();
        persistingConfig.addOrReplaceGridSet(new XMLGridSet(gridSet));
        persistingConfig.save();
        this.gridSetBroker.put(gridSet);
    }

    private XMLConfiguration getXmlConfiguration() throws IllegalStateException {
        for (Configuration c : this.configs) {
            if (!(c instanceof XMLConfiguration)) continue;
            return (XMLConfiguration)c;
        }
        throw new IllegalStateException("Found no configuration of type " + XMLConfiguration.class.getName());
    }
}

