/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.io;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.geowebcache.GeoWebCacheExtensions;

public class GeoWebCacheXStream
extends XStream {
    public GeoWebCacheXStream() {
        this.secure();
    }

    public GeoWebCacheXStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        super(hierarchicalStreamDriver);
        this.secure();
    }

    public GeoWebCacheXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry) {
        super(reflectionProvider, driver, classLoaderReference, mapper, converterLookup, converterRegistry);
        this.secure();
    }

    public GeoWebCacheXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference, Mapper mapper) {
        super(reflectionProvider, driver, classLoaderReference, mapper);
        this.secure();
    }

    public GeoWebCacheXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference) {
        super(reflectionProvider, driver, classLoaderReference);
        this.secure();
    }

    public GeoWebCacheXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        super(reflectionProvider, hierarchicalStreamDriver);
        this.secure();
    }

    public GeoWebCacheXStream(ReflectionProvider reflectionProvider) {
        super(reflectionProvider);
        this.secure();
    }

    @Deprecated
    public GeoWebCacheXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry) {
        super(reflectionProvider, driver, classLoader, mapper, converterLookup, converterRegistry);
        this.secure();
    }

    @Deprecated
    public GeoWebCacheXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader, Mapper mapper) {
        super(reflectionProvider, driver, classLoader, mapper);
        this.secure();
    }

    @Deprecated
    public GeoWebCacheXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader) {
        super(reflectionProvider, driver, classLoader);
        this.secure();
    }

    @Deprecated
    public GeoWebCacheXStream(ReflectionProvider reflectionProvider, Mapper mapper, HierarchicalStreamDriver driver) {
        super(reflectionProvider, mapper, driver);
        this.secure();
    }

    public void allowTypeHierarchies(Class<?> ... types) {
        for (Class<?> type : types) {
            this.allowTypeHierarchy(type);
        }
    }

    private void secure() {
        this.addPermission(NoTypePermission.NONE);
        this.addPermission((TypePermission)new PrimitiveTypePermission());
        this.allowTypes(new Class[]{String.class, java.util.Date.class, Date.class, Timestamp.class, Time.class});
        this.allowTypes(new Class[]{TreeSet.class, SortedSet.class, Set.class, HashSet.class, List.class, ArrayList.class, Map.class, HashMap.class, CopyOnWriteArrayList.class, ConcurrentHashMap.class});
        String whitelistProp = GeoWebCacheExtensions.getProperty("GEOWEBCACHE_XSTREAM_WHITELIST");
        if (whitelistProp != null) {
            String[] wildcards = whitelistProp.split("\\s+|(\\s*;\\s*)");
            this.allowTypesByWildcard(wildcards);
        }
    }
}

