/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.List;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridMismatchException;
import org.geowebcache.grid.GridSubset;

public class GridUtil {
    public static GridSubset findBestMatchingGrid(BoundingBox reqBounds, List<GridSubset> crsMatchingGridSubsets, Integer expectedTileWidth, Integer expectedTileHeight, long[] matchingTileIndexTarget) {
        GridSubset bestMatch = null;
        long[] bestMatchingTileIndex = null;
        for (GridSubset crsMatch : crsMatchingGridSubsets) {
            try {
                int tileWidth = crsMatch.getTileWidth();
                int tileHeight = crsMatch.getTileHeight();
                if (expectedTileWidth != null && expectedTileWidth != tileWidth || expectedTileHeight != null && expectedTileHeight != tileHeight) continue;
                long[] matchingTileIndex = crsMatch.closestIndex(reqBounds);
                if (bestMatch == null) {
                    bestMatch = crsMatch;
                    bestMatchingTileIndex = matchingTileIndex;
                    continue;
                }
                BoundingBox previousBounds = bestMatch.boundsFromIndex(bestMatchingTileIndex);
                BoundingBox bounds = crsMatch.boundsFromIndex(matchingTileIndex);
                double reqArea = reqBounds.getWidth() * reqBounds.getHeight();
                double previousArea = previousBounds.getWidth() * previousBounds.getHeight();
                double currArea = bounds.getWidth() * bounds.getHeight();
                double deltaPrev = Math.abs(reqArea - previousArea);
                double deltaCurr = Math.abs(reqArea - currArea);
                if (!(deltaCurr < deltaPrev)) continue;
                bestMatch = crsMatch;
                bestMatchingTileIndex = matchingTileIndex;
            }
            catch (GridMismatchException doesNotMatch) {}
        }
        if (bestMatchingTileIndex != null) {
            System.arraycopy(bestMatchingTileIndex, 0, matchingTileIndexTarget, 0, 3);
        }
        return bestMatch;
    }
}

