/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridCoverage;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSubset;

public class GridSubsetFactory {
    private static Log log = LogFactory.getLog(GridSubsetFactory.class);

    public static GridSubset createGridSubSet(GridSet gridSet) {
        GridSubset ret = GridSubsetFactory.createGridSubSet(gridSet, gridSet.getOriginalExtent(), 0, gridSet.getGridLevels().length - 1);
        return ret;
    }

    public static GridSubset createGridSubSet(GridSet gridSet, BoundingBox extent, Integer zoomStart, Integer zoomStop) {
        return GridSubsetFactory.createGridSubSet(gridSet, extent, zoomStart, zoomStop, null, null);
    }

    public static GridSubset createGridSubSet(GridSet gridSet, BoundingBox extent, Integer zoomStart, Integer zoomStop, Integer minCachedZoom, Integer maxCachedZoom) {
        if (gridSet == null) {
            log.error((Object)"Passed GridSet was null!");
        }
        Grid[] gridLevels = gridSet.getGridLevels();
        int maxLevel = gridLevels.length - 1;
        if (zoomStart == null) {
            zoomStart = 0;
        }
        if (zoomStop == null) {
            zoomStop = maxLevel;
        } else if (zoomStop > maxLevel) {
            String message = "Requested to create GridSubset with zoomStop " + zoomStop + " for GridSet " + gridSet.getName() + " whose max zoom level is " + maxLevel + ". Limiting GridSubset to zoomStop = " + maxLevel;
            log.warn((Object)message);
            zoomStop = maxLevel;
        }
        TreeMap<Integer, GridCoverage> coverages = new TreeMap<Integer, GridCoverage>();
        for (int z = zoomStart.intValue(); z <= zoomStop; ++z) {
            long[] coverage;
            Grid level = gridLevels[z];
            if (extent == null) {
                long maxColX = level.getNumTilesWide() - 1L;
                long maxColY = level.getNumTilesHigh() - 1L;
                coverage = new long[]{0L, 0L, maxColX, maxColY, z};
            } else {
                coverage = gridSet.closestRectangle(z, extent);
            }
            GridCoverage gridCov = new GridCoverage(coverage);
            coverages.put(z, gridCov);
        }
        BoundingBox originalExtent = extent;
        boolean fullCoverage = false;
        BoundingBox gridSetBounds = gridSet.getBounds();
        if (extent == null || extent.contains(gridSetBounds)) {
            fullCoverage = true;
            originalExtent = gridSetBounds;
        }
        GridSubset ret = new GridSubset(gridSet, coverages, originalExtent, fullCoverage, minCachedZoom, maxCachedZoom);
        return ret;
    }
}

