/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.Arrays;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridAlignmentMismatchException;
import org.geowebcache.grid.GridMismatchException;
import org.geowebcache.grid.ResolutionMismatchException;
import org.geowebcache.grid.SRS;

public class GridSet {
    private String name;
    private SRS srs;
    private int tileWidth;
    private int tileHeight;
    protected boolean yBaseToggle = false;
    private boolean yCoordinateFirst = false;
    private boolean scaleWarning = false;
    private double metersPerUnit;
    private double pixelSize;
    private BoundingBox originalExtent;
    private Grid[] gridLevels;
    private String description;
    private boolean resolutionsPreserved;

    protected GridSet() {
    }

    public BoundingBox getOriginalExtent() {
        return this.originalExtent;
    }

    void setOriginalExtent(BoundingBox originalExtent) {
        this.originalExtent = originalExtent;
    }

    public boolean isResolutionsPreserved() {
        return this.resolutionsPreserved;
    }

    void setResolutionsPreserved(boolean resolutionsPreserved) {
        this.resolutionsPreserved = resolutionsPreserved;
    }

    protected BoundingBox boundsFromIndex(long[] tileIndex) {
        int tileZ = (int)tileIndex[2];
        Grid grid = this.getGrid(tileZ);
        long tileX = tileIndex[0];
        long tileY = this.yBaseToggle ? tileIndex[1] - grid.getNumTilesHigh() : tileIndex[1];
        double width = grid.getResolution() * (double)this.getTileWidth();
        double height = grid.getResolution() * (double)this.getTileHeight();
        double[] tileOrigin = this.tileOrigin();
        BoundingBox tileBounds = new BoundingBox(tileOrigin[0] + width * (double)tileX, tileOrigin[1] + height * (double)tileY, tileOrigin[0] + width * (double)(tileX + 1L), tileOrigin[1] + height * (double)(tileY + 1L));
        return tileBounds;
    }

    protected BoundingBox boundsFromRectangle(long[] rectangleExtent) {
        Grid grid = this.getGridLevels()[(int)rectangleExtent[4]];
        double width = grid.getResolution() * (double)this.getTileWidth();
        double height = grid.getResolution() * (double)this.getTileHeight();
        long bottomY = rectangleExtent[1];
        long topY = rectangleExtent[3];
        if (this.yBaseToggle) {
            bottomY -= grid.getNumTilesHigh();
            topY -= grid.getNumTilesHigh();
        }
        double[] tileOrigin = this.tileOrigin();
        double minx = tileOrigin[0] + width * (double)rectangleExtent[0];
        double miny = tileOrigin[1] + height * (double)bottomY;
        double maxx = tileOrigin[0] + width * (double)(rectangleExtent[2] + 1L);
        double maxy = tileOrigin[1] + height * (double)(topY + 1L);
        BoundingBox rectangleBounds = new BoundingBox(minx, miny, maxx, maxy);
        return rectangleBounds;
    }

    protected long[] closestIndex(BoundingBox tileBounds) throws GridMismatchException {
        Grid grid;
        double error;
        double wRes = tileBounds.getWidth() / (double)this.getTileWidth();
        double bestError = Double.MAX_VALUE;
        int bestLevel = -1;
        double bestResolution = -1.0;
        int i = 0;
        while (i < this.getGridLevels().length && (error = Math.abs(wRes - (grid = this.getGridLevels()[i]).getResolution())) < bestError) {
            bestError = error;
            bestResolution = grid.getResolution();
            bestLevel = i++;
        }
        if (Math.abs(wRes - bestResolution) > 0.1 * wRes) {
            throw new ResolutionMismatchException(wRes, bestResolution);
        }
        return this.closestIndex(bestLevel, tileBounds);
    }

    protected long[] closestIndex(int level, BoundingBox tileBounds) throws GridAlignmentMismatchException {
        Grid grid = this.getGridLevels()[level];
        double width = grid.getResolution() * (double)this.getTileWidth();
        double height = grid.getResolution() * (double)this.getTileHeight();
        double x = (tileBounds.getMinX() - this.tileOrigin()[0]) / width;
        double y = (tileBounds.getMinY() - this.tileOrigin()[1]) / height;
        long posX = Math.round(x);
        long posY = Math.round(y);
        if (x - (double)posX > 0.1 || y - (double)posY > 0.1) {
            throw new GridAlignmentMismatchException(x, posX, y, posY);
        }
        if (this.yBaseToggle) {
            posY += grid.getNumTilesHigh();
        }
        long[] ret = new long[]{posX, posY, level};
        return ret;
    }

    public long[] closestRectangle(BoundingBox rectangleBounds) {
        double rectWidth = rectangleBounds.getWidth();
        double rectHeight = rectangleBounds.getHeight();
        double bestError = Double.MAX_VALUE;
        int bestLevel = -1;
        for (int i = 0; i < this.getGridLevels().length; ++i) {
            Grid grid = this.getGridLevels()[i];
            double countX = rectWidth / (grid.getResolution() * (double)this.getTileWidth());
            double countY = rectHeight / (grid.getResolution() * (double)this.getTileHeight());
            double error = Math.abs(countX - (double)Math.round(countX)) + Math.abs(countY - (double)Math.round(countY));
            if (error < bestError) {
                bestError = error;
                bestLevel = i;
                continue;
            }
            if (error >= bestError) break;
        }
        return this.closestRectangle(bestLevel, rectangleBounds);
    }

    protected long[] closestRectangle(int level, BoundingBox rectangeBounds) {
        Grid grid = this.getGridLevels()[level];
        double width = grid.getResolution() * (double)this.getTileWidth();
        double height = grid.getResolution() * (double)this.getTileHeight();
        long minX = (long)Math.floor((rectangeBounds.getMinX() - this.tileOrigin()[0]) / width);
        long minY = (long)Math.floor((rectangeBounds.getMinY() - this.tileOrigin()[1]) / height);
        long maxX = (long)Math.ceil((rectangeBounds.getMaxX() - this.tileOrigin()[0]) / width);
        long maxY = (long)Math.ceil((rectangeBounds.getMaxY() - this.tileOrigin()[1]) / height);
        if (this.yBaseToggle) {
            minY += grid.getNumTilesHigh();
            maxY += grid.getNumTilesHigh();
        }
        long[] ret = new long[]{minX, minY, maxX - 1L, maxY - 1L, level};
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GridSet)) {
            return false;
        }
        GridSet other = (GridSet)obj;
        if (this == other) {
            return true;
        }
        boolean equals = ObjectUtils.equals((Object)this.getSrs(), (Object)other.getSrs()) && ObjectUtils.equals((Object)this.getName(), (Object)other.getName()) && ObjectUtils.equals((Object)this.getDescription(), (Object)other.getDescription()) && ObjectUtils.equals((Object)this.getTileWidth(), (Object)other.getTileWidth()) && ObjectUtils.equals((Object)this.getTileHeight(), (Object)other.getTileHeight()) && ObjectUtils.equals((Object)this.isTopLeftAligned(), (Object)other.isTopLeftAligned()) && ObjectUtils.equals((Object)this.isyCoordinateFirst(), (Object)other.isyCoordinateFirst()) && ObjectUtils.equals((Object)this.getOriginalExtent(), (Object)other.getOriginalExtent()) && Arrays.equals(this.getGridLevels(), other.getGridLevels());
        return equals;
    }

    public int hashCode() {
        int hashCode = HashCodeBuilder.reflectionHashCode((Object)this);
        return hashCode;
    }

    public BoundingBox getBounds() {
        long tilesHigh;
        long tilesWide;
        int i;
        for (i = this.getGridLevels().length - 1; i > 0; --i) {
            tilesWide = this.getGridLevels()[i].getNumTilesWide();
            tilesHigh = this.getGridLevels()[i].getNumTilesHigh();
            if (tilesWide == 1L && tilesHigh == 0L) break;
        }
        tilesWide = this.getGridLevels()[i].getNumTilesWide();
        tilesHigh = this.getGridLevels()[i].getNumTilesHigh();
        long[] ret = new long[]{0L, 0L, tilesWide - 1L, tilesHigh - 1L, i};
        return this.boundsFromRectangle(ret);
    }

    public double[] getOrderedTopLeftCorner(int gridIndex) {
        double[] leftTop = new double[2];
        if (this.yBaseToggle) {
            leftTop[0] = this.tileOrigin()[0];
            leftTop[1] = this.tileOrigin()[1];
        } else {
            Grid grid = this.getGridLevels()[gridIndex];
            double dTileHeight = this.getTileHeight();
            double dGridExtent = grid.getNumTilesHigh();
            double top = this.tileOrigin()[1] + dTileHeight * grid.getResolution() * dGridExtent;
            if (Math.abs(top - (double)Math.round(top)) < top / 200.0) {
                top = Math.round(top);
            }
            leftTop[0] = this.tileOrigin()[0];
            leftTop[1] = top;
        }
        if (this.isyCoordinateFirst()) {
            double[] ret = new double[]{leftTop[1], leftTop[0]};
            return ret;
        }
        return leftTop;
    }

    public String guessMapUnits() {
        if (113000.0 > this.getMetersPerUnit() && this.getMetersPerUnit() > 110000.0) {
            return "degrees";
        }
        if (1100.0 > this.getMetersPerUnit() && this.getMetersPerUnit() > 900.0) {
            return "kilometers";
        }
        if (1.1 > this.getMetersPerUnit() && this.getMetersPerUnit() > 0.9) {
            return "meters";
        }
        if (0.4 > this.getMetersPerUnit() && this.getMetersPerUnit() > 0.28) {
            return "feet";
        }
        if (0.03 > this.getMetersPerUnit() && this.getMetersPerUnit() > 0.02) {
            return "inches";
        }
        if (0.02 > this.getMetersPerUnit() && this.getMetersPerUnit() > 0.005) {
            return "centimeters";
        }
        if (0.002 > this.getMetersPerUnit() && this.getMetersPerUnit() > 5.0E-4) {
            return "millimeters";
        }
        return "unknown";
    }

    public boolean isTopLeftAligned() {
        return this.yBaseToggle;
    }

    void setTopLeftAligned(boolean yBaseToggle) {
        this.yBaseToggle = yBaseToggle;
    }

    public int getNumLevels() {
        return this.gridLevels.length;
    }

    @Deprecated
    public Grid[] getGridLevels() {
        return this.gridLevels;
    }

    public Grid getGrid(int zLevel) {
        return this.gridLevels[zLevel];
    }

    void setGridLevels(Grid[] gridLevels) {
        this.gridLevels = gridLevels;
    }

    public double[] tileOrigin() {
        BoundingBox extent = this.getOriginalExtent();
        double[] tileOrigin = new double[]{extent.getMinX(), this.yBaseToggle ? extent.getMaxY() : extent.getMinY()};
        return tileOrigin;
    }

    public boolean isyCoordinateFirst() {
        return this.yCoordinateFirst;
    }

    void setyCoordinateFirst(boolean yCoordinateFirst) {
        this.yCoordinateFirst = yCoordinateFirst;
    }

    public boolean isScaleWarning() {
        return this.scaleWarning;
    }

    void setScaleWarning(boolean scaleWarning) {
        this.scaleWarning = scaleWarning;
    }

    public double getMetersPerUnit() {
        return this.metersPerUnit;
    }

    void setMetersPerUnit(double metersPerUnit) {
        this.metersPerUnit = metersPerUnit;
    }

    public double getPixelSize() {
        return this.pixelSize;
    }

    void setPixelSize(double pixelSize) {
        this.pixelSize = pixelSize;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SRS getSrs() {
        return this.srs;
    }

    void setSrs(SRS srs) {
        this.srs = srs;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public boolean shouldTruncateIfChanged(GridSet another) {
        Grid[] otherGrids;
        boolean needsTruncate = !this.getBounds().equals(another.getBounds());
        needsTruncate |= this.isTopLeftAligned() != another.isTopLeftAligned();
        needsTruncate |= this.getTileWidth() != another.getTileWidth();
        needsTruncate |= this.getTileHeight() != another.getTileHeight();
        if (needsTruncate |= !this.getSrs().equals(another.getSrs())) {
            return true;
        }
        Grid[] myGrids = this.getGridLevels();
        if (myGrids.length > (otherGrids = another.getGridLevels()).length) {
            return true;
        }
        for (int i = 0; i < myGrids.length; ++i) {
            if (myGrids[i].equals(otherGrids[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

