/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.request;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.BlankTileException;
import org.geowebcache.filter.request.GreenTileException;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.layer.TileLayer;

public abstract class RasterFilter
extends RequestFilter {
    private static final long serialVersionUID = -5695649347572928323L;
    private static Log log = LogFactory.getLog(RasterFilter.class);
    private Integer zoomStart;
    private Integer zoomStop;
    private Boolean resample;
    private Boolean preload;
    private Boolean debug;
    public transient Hashtable<String, BufferedImage[]> matrices;

    public Integer getZoomStart() {
        return this.zoomStart;
    }

    public void setZoomStart(Integer zoomStart) {
        this.zoomStart = zoomStart;
    }

    public Integer getZoomStop() {
        return this.zoomStop;
    }

    public void setZoomStop(Integer zoomStop) {
        this.zoomStop = zoomStop;
    }

    public Boolean getResample() {
        return this.resample;
    }

    public void setResample(Boolean resample) {
        this.resample = resample;
    }

    public Boolean getPreload() {
        return this.preload;
    }

    public void setPreload(Boolean preload) {
        this.preload = preload;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    @Override
    public void apply(ConveyorTile convTile) throws RequestFilterException {
        long[] idx = (long[])convTile.getTileIndex().clone();
        String gridSetId = convTile.getGridSetId();
        try {
            convTile.getGridSubset().checkCoverage(idx);
        }
        catch (OutsideCoverageException oce) {
            throw new BlankTileException(this);
        }
        int zoomDiff = 0;
        if (this.zoomStart != null && idx[2] < (long)this.zoomStart.intValue()) {
            if (this.resample == null || !this.resample.booleanValue()) {
                return;
            }
            zoomDiff = (int)(idx[2] - (long)this.zoomStart.intValue());
            idx[0] = idx[0] << -1 * zoomDiff;
            idx[1] = idx[1] << -1 * zoomDiff;
            idx[2] = this.zoomStart.intValue();
        } else if (idx[2] < (long)this.zoomStop.intValue()) {
            idx[0] = idx[0] * 2L;
            idx[1] = idx[1] * 2L;
            idx[2] = idx[2] + 1L;
        } else {
            zoomDiff = (int)(idx[2] - (long)this.zoomStop.intValue());
            idx[0] = idx[0] >> zoomDiff;
            idx[1] = idx[1] >> zoomDiff;
            idx[2] = this.zoomStop.intValue();
        }
        if (this.matrices == null || this.matrices.get(gridSetId) == null || this.matrices.get(gridSetId)[(int)idx[2]] == null) {
            try {
                this.setMatrix(convTile.getLayer(), gridSetId, (int)idx[2], false);
            }
            catch (Exception e) {
                log.error((Object)("Failed to load matrix for " + this.getName() + ", " + gridSetId + ", " + idx[2] + " : " + e.getMessage()));
                throw new RequestFilterException(this, 500, "Failed while trying to load filter for " + idx[2] + ", please check the logs");
            }
        }
        if (zoomDiff == 0) {
            if (!this.lookup(convTile.getGridSubset(), idx)) {
                if (this.debug != null && this.debug.booleanValue()) {
                    throw new GreenTileException(this);
                }
                throw new BlankTileException(this);
            }
        } else if (zoomDiff > 0) {
            if (!this.lookupQuad(convTile.getGridSubset(), idx)) {
                if (this.debug != null && this.debug.booleanValue()) {
                    throw new GreenTileException(this);
                }
                throw new BlankTileException(this);
            }
        } else if (zoomDiff < 0 && !this.lookupSubsample(convTile.getGridSubset(), idx, zoomDiff)) {
            if (this.debug != null && this.debug.booleanValue()) {
                throw new GreenTileException(this);
            }
            throw new BlankTileException(this);
        }
    }

    @Override
    public void initialize(TileLayer layer) throws GeoWebCacheException {
        if (this.preload != null && this.preload.booleanValue()) {
            for (String gridSetId : layer.getGridSubsets()) {
                GridSubset grid = layer.getGridSubset(gridSetId);
                for (int i = 0; i <= this.zoomStop; ++i) {
                    try {
                        this.setMatrix(layer, grid.getName(), i, false);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to load matrix for " + this.getName() + ", " + grid.getName() + ", " + i + " : " + e.getMessage()));
                    }
                }
            }
        }
    }

    private boolean lookup(GridSubset grid, long[] idx) {
        BufferedImage mat = this.matrices.get(grid.getName())[(int)idx[2]];
        long[] gridCoverage = grid.getCoverage((int)idx[2]);
        long x = idx[0] - gridCoverage[0];
        long y = gridCoverage[3] - idx[1];
        return mat.getRaster().getSample((int)x, (int)y, 0) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lookupQuad(GridSubset grid, long[] idx) {
        BufferedImage mat = this.matrices.get(grid.getName())[(int)idx[2]];
        long[] gridCoverage = grid.getCoverage((int)idx[2]);
        int baseX = (int)(idx[0] - gridCoverage[0]);
        int baseY = (int)(gridCoverage[3] - idx[1]);
        int width = mat.getWidth();
        int height = mat.getHeight();
        int x = baseX;
        int y = baseY;
        boolean hasData = false;
        int[] xOffsets = new int[]{0, 1, 0, 1};
        int[] yOffsets = new int[]{0, 0, 1, 1};
        BufferedImage bufferedImage = mat;
        synchronized (bufferedImage) {
            try {
                for (int i = 0; i < 4 && !hasData; ++i) {
                    x = baseX + xOffsets[i];
                    y = baseY - yOffsets[i];
                    if (x <= -1 || x >= width || y <= -1 || y >= height || mat.getRaster().getSample(x, y, 0) != 0) continue;
                    hasData = true;
                }
            }
            catch (ArrayIndexOutOfBoundsException aioob) {
                log.error((Object)("x:" + x + "  y:" + y + " (" + mat.getWidth() + " " + mat.getHeight() + ")"));
            }
        }
        return hasData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lookupSubsample(GridSubset grid, long[] idx, int zoomDiff) {
        BufferedImage mat = this.matrices.get(grid.getName())[(int)idx[2]];
        int sampleChange = 1 << -1 * zoomDiff;
        long[] gridCoverage = grid.getCoverage((int)idx[2]);
        int baseX = (int)(idx[0] - gridCoverage[0]);
        int baseY = (int)(gridCoverage[3] - idx[1]);
        int width = mat.getWidth();
        int height = mat.getHeight();
        int startX = Math.max(0, baseX);
        int stopX = Math.min(width, baseX + sampleChange);
        int startY = Math.min(baseY, height - 1);
        int stopY = Math.max(0, baseY - sampleChange);
        int x = -1;
        int y = -1;
        BufferedImage bufferedImage = mat;
        synchronized (bufferedImage) {
            try {
                x = (stopX + startX) / 2;
                y = (startY + stopY) / 2;
                if (mat.getRaster().getSample(x, y, 0) == 0 || mat.getRaster().getSample(stopX - 1, stopY + 1, 0) == 0 || mat.getRaster().getSample(stopX - 1, startY, 0) == 0 || mat.getRaster().getSample(startX, stopY + 1, 0) == 0) {
                    return true;
                }
                y = startY;
                for (x = startX; x < stopX; ++x) {
                    while (y > stopY) {
                        if (mat.getRaster().getSample(x, y, 0) == 0) {
                            return true;
                        }
                        --y;
                    }
                    y = startY;
                }
            }
            catch (ArrayIndexOutOfBoundsException aioob) {
                log.error((Object)("x:" + x + "  y:" + y + " (" + mat.getWidth() + " " + mat.getHeight() + ")"));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMatrix(TileLayer layer, String gridSetId, int z, boolean replace) throws IOException, GeoWebCacheException {
        if (this.matrices == null) {
            this.matrices = new Hashtable();
        }
        if (this.matrices.get(gridSetId) == null) {
            this.matrices.put(gridSetId, new BufferedImage[this.zoomStop + 1]);
        }
        if (this.matrices.get(gridSetId)[z] == null) {
            this.matrices.get((Object)gridSetId)[z] = this.loadMatrix(layer, gridSetId, z);
        } else if (replace) {
            BufferedImage oldImg = this.matrices.get(gridSetId)[z];
            BufferedImage[] matArray = this.matrices.get(gridSetId);
            BufferedImage newImg = this.loadMatrix(layer, gridSetId, z);
            BufferedImage bufferedImage = oldImg;
            synchronized (bufferedImage) {
                matArray[z] = newImg;
            }
        }
    }

    protected int[] calculateWidthHeight(GridSubset grid, int z) throws GeoWebCacheException {
        long[] bounds = grid.getCoverage(z);
        int[] widthHeight = new int[]{(int)(bounds[2] - bounds[0] + 1L), (int)(bounds[3] - bounds[1] + 1L)};
        return widthHeight;
    }

    protected abstract BufferedImage loadMatrix(TileLayer var1, String var2, int var3) throws IOException, GeoWebCacheException;
}

