/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.request;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.request.RasterFilter;
import org.geowebcache.layer.TileLayer;

public class FileRasterFilter
extends RasterFilter {
    private static final long serialVersionUID = -6950985531575208956L;
    private String storagePath;
    private String fileExtension;

    String getStoragePath() {
        return this.storagePath;
    }

    void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    String getFileExtension() {
        return this.fileExtension;
    }

    void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Override
    protected BufferedImage loadMatrix(TileLayer layer, String gridSetId, int zoomLevel) throws IOException, GeoWebCacheException {
        File fh = new File(this.createFilePath(gridSetId, zoomLevel));
        if (!fh.exists() || !fh.canRead()) {
            throw new GeoWebCacheException(fh.getAbsolutePath() + " does not exist or is not readable");
        }
        BufferedImage img = ImageIO.read(fh);
        int[] widthHeight = this.calculateWidthHeight(layer.getGridSubset(gridSetId), zoomLevel);
        if (img.getWidth() != widthHeight[0] || img.getHeight() != widthHeight[1]) {
            String msg = fh.getAbsolutePath() + " has dimensions " + img.getWidth() + "," + img.getHeight() + ", expected " + widthHeight[0] + "," + widthHeight[1];
            throw new GeoWebCacheException(msg);
        }
        return img;
    }

    private String createFilePath(String gridSetId, int zoomLevel) {
        String path = this.storagePath + File.separator + this.getName() + "_" + gridSetId + "_" + zoomLevel + "." + this.fileExtension;
        return path;
    }

    public void saveMatrix(byte[] data, TileLayer layer, String gridSetId, int zoomLevel) throws IOException {
        File fh = new File(this.createFilePath(gridSetId, zoomLevel));
        FileOutputStream fos = new FileOutputStream(fh);
        fos.write(data);
        fos.close();
    }

    @Override
    public void update(byte[] filterData, TileLayer layer, String gridSetId, int z) throws GeoWebCacheException {
        try {
            this.saveMatrix(filterData, layer, gridSetId, z);
        }
        catch (IOException e) {
            throw new GeoWebCacheException(this.getName() + " encountered an error while persisting matrix, " + e.getMessage());
        }
        try {
            super.setMatrix(layer, gridSetId, z, true);
        }
        catch (IOException e) {
            throw new GeoWebCacheException(this.getName() + " encountered an error while loading matrix, " + e.getMessage());
        }
    }

    @Override
    public void update(TileLayer layer, String gridSetId, int zoomStart, int zoomStop) throws GeoWebCacheException {
        throw new GeoWebCacheException("TileLayer layer, String gridSetId, int z) is not appropriate for FileRasterFilters");
    }

    @Override
    public boolean update(TileLayer layer, String gridSetId) {
        return false;
    }
}

