/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.request;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;

public class BlankTileException
extends RequestFilterException {
    private static final long serialVersionUID = 6910805463474341350L;
    private static Log log = LogFactory.getLog(BlankTileException.class);
    private static volatile Resource blankTile;

    public BlankTileException(RequestFilter reqFilter) {
        super(reqFilter, 200, "image/png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getBlankTile() {
        InputStream is = null;
        try {
            is = GeoWebCacheDispatcher.class.getResourceAsStream("blank.png");
            byte[] blankTile = new byte[425];
            int ret = is.read(blankTile);
            log.info((Object)("Read " + ret + " from blank PNG file (expected 425)."));
            ByteArrayResource byteArrayResource = new ByteArrayResource(blankTile);
            return byteArrayResource;
        }
        catch (IOException ioe) {
            log.error((Object)ioe.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Resource getResponse() {
        Resource ret = blankTile;
        if (ret != null) return ret;
        Class<BlankTileException> clazz = BlankTileException.class;
        synchronized (BlankTileException.class) {
            ret = blankTile;
            if (ret != null) return ret;
            blankTile = ret = this.getBlankTile();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }
}

