/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.geowebcache.filter.parameters.CaseNormalizingParameterFilter;
import org.geowebcache.filter.parameters.ParameterException;

@ParametersAreNonnullByDefault
@XStreamAlias(value="stringParameterFilter")
public class StringParameterFilter
extends CaseNormalizingParameterFilter {
    private static final long serialVersionUID = 7383381085250203901L;
    private List<String> values = new ArrayList<String>(0);

    @Override
    protected StringParameterFilter readResolve() {
        super.readResolve();
        if (this.values == null) {
            this.values = new ArrayList<String>(0);
        }
        for (String value : this.values) {
            Preconditions.checkNotNull((Object)value, (Object)"Value list included a null pointer.");
        }
        return this;
    }

    @Override
    public String apply(@Nullable String str) throws ParameterException {
        if (str == null || str.length() == 0) {
            return this.getDefaultValue();
        }
        str = this.getNormalize().apply(str);
        if (this.getLegalValues().contains(str)) {
            return str;
        }
        throw new ParameterException(str + " violates filter for parameter " + this.getKey());
    }

    @Override
    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void setValues(List<String> values) {
        Preconditions.checkNotNull(values);
        for (String value : values) {
            Preconditions.checkNotNull((Object)value, (Object)"Value list included a null pointer.");
        }
        this.values = new ArrayList<String>(values);
    }

    @Override
    public boolean applies(@Nullable String parameterValue) {
        return this.getLegalValues().contains(this.getNormalize().apply(parameterValue));
    }

    @Override
    public StringParameterFilter clone() {
        StringParameterFilter clone = new StringParameterFilter();
        clone.setDefaultValue(this.getDefaultValue());
        clone.setKey(this.getKey());
        if (this.values != null) {
            clone.values = new ArrayList<String>(this.values);
        }
        clone.setNormalize(this.getNormalize().clone());
        return clone;
    }
}

