/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.geowebcache.filter.parameters.ParameterException;

@ParametersAreNonnullByDefault
public abstract class ParameterFilter
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -531248230951783132L;
    private String key;
    private String defaultValue = "";

    public ParameterFilter() {
    }

    public ParameterFilter(String key, @Nullable String defaultValue) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"Parameter key must not be empty.");
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public ParameterFilter(String key) {
        this(key, "");
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.defaultValue;
    }

    public abstract ParameterFilter clone();

    public boolean applies(@Nullable String parameterValue) {
        try {
            this.apply(parameterValue);
        }
        catch (ParameterException e) {
            return false;
        }
        return true;
    }

    public abstract String apply(@Nullable String var1) throws ParameterException;

    @Nullable
    public abstract List<String> getLegalValues();

    public void setKey(String key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"ParameterFilter key must be non-empty");
        Preconditions.checkState((this.key == null ? 1 : 0) != 0, (Object)"The key for this ParameterFilter has already been set");
        this.key = key;
    }

    public void setDefaultValue(@Nullable String defaultValue) {
        if (defaultValue == null) {
            defaultValue = "";
        }
        this.defaultValue = defaultValue;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    protected ParameterFilter readResolve() {
        Preconditions.checkNotNull((Object)this.key);
        Preconditions.checkState((!this.key.isEmpty() ? 1 : 0) != 0, (Object)"ParameterFilter key must be non-empty");
        if (this.defaultValue == null) {
            this.defaultValue = "";
        }
        return this;
    }
}

