/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;

@ParametersAreNonnullByDefault
@XStreamAlias(value="integerParameterFilter")
public class IntegerParameterFilter
extends ParameterFilter {
    private static Integer DEFAULT_THRESHOLD = 1;
    private List<Integer> values = new ArrayList<Integer>(0);
    private Integer threshold;

    @Override
    protected IntegerParameterFilter readResolve() {
        super.readResolve();
        if (this.values == null) {
            this.values = new ArrayList<Integer>(0);
        }
        if (this.threshold == null) {
            this.threshold = this.getDefaultThreshold();
        }
        for (Integer value : this.values) {
            Preconditions.checkNotNull((Object)value, (Object)"Value list included a null pointer.");
        }
        return this;
    }

    protected Integer getDefaultThreshold() {
        return DEFAULT_THRESHOLD;
    }

    public List<Integer> getValues() {
        return this.values;
    }

    public void setValues(List<Integer> values) {
        Preconditions.checkNotNull(values);
        for (Integer f : values) {
            Preconditions.checkNotNull((Object)f);
        }
        this.values = new ArrayList<Integer>(values);
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(@Nullable Integer threshold) {
        if (threshold == null) {
            threshold = this.getDefaultThreshold();
        }
        this.threshold = threshold;
    }

    @Override
    public String apply(@Nullable String str) throws ParameterException {
        if (str == null || str.length() == 0) {
            return this.getDefaultValue();
        }
        int val = Integer.parseInt(str);
        if (this.values.isEmpty()) {
            return String.valueOf(val);
        }
        int best = Integer.MIN_VALUE;
        int bestMismatch = Integer.MAX_VALUE;
        for (int fl : this.getValues()) {
            int mismatch = Math.abs(fl - val);
            if (mismatch >= bestMismatch) continue;
            best = fl;
            bestMismatch = mismatch;
        }
        if (this.threshold != null && this.threshold > 0 && Math.abs(bestMismatch) < this.threshold) {
            return Integer.toString(best);
        }
        throw new ParameterException("Closest match for " + super.getKey() + "=" + str + " is " + Integer.toString(best) + ", but this exceeds the threshold of " + Integer.toString(this.threshold));
    }

    @Override
    @Nullable
    public List<String> getLegalValues() {
        LinkedList<String> ret = new LinkedList<String>();
        Iterator<Integer> iter = this.getValues().iterator();
        while (iter.hasNext()) {
            ret.add(Integer.toString(iter.next()));
        }
        return ret;
    }

    @Override
    public IntegerParameterFilter clone() {
        IntegerParameterFilter clone = new IntegerParameterFilter();
        clone.setDefaultValue(this.getDefaultValue());
        clone.setKey(this.getKey());
        if (this.values != null) {
            clone.values = new ArrayList<Integer>(this.values);
        }
        clone.setThreshold(this.threshold);
        return clone;
    }
}

