/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;

@ParametersAreNonnullByDefault
@XStreamAlias(value="floatParameterFilter")
public class FloatParameterFilter
extends ParameterFilter {
    private static final long serialVersionUID = 4186888723396139208L;
    private static Float DEFAULT_THRESHOLD = Float.valueOf(1.0E-6f);
    private List<Float> values = new ArrayList<Float>(0);
    private Float threshold;

    @Override
    protected FloatParameterFilter readResolve() {
        super.readResolve();
        if (this.values == null) {
            this.values = new ArrayList<Float>(0);
        }
        if (this.threshold == null) {
            this.threshold = this.getDefaultThreshold();
        }
        for (Float value : this.values) {
            Preconditions.checkNotNull((Object)value, (Object)"Value list included a null pointer.");
        }
        return this;
    }

    protected Float getDefaultThreshold() {
        return DEFAULT_THRESHOLD;
    }

    public List<Float> getValues() {
        return this.values;
    }

    public void setValues(List<Float> values) {
        Preconditions.checkNotNull(values);
        for (Float f : values) {
            Preconditions.checkNotNull((Object)f);
        }
        this.values = new ArrayList<Float>(values);
    }

    public Float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(@Nullable Float threshold) {
        if (threshold == null) {
            threshold = this.getDefaultThreshold();
        }
        this.threshold = threshold;
    }

    @Override
    public String apply(@Nullable String str) throws ParameterException {
        if (str == null || str.length() == 0) {
            return this.getDefaultValue();
        }
        float val = Float.parseFloat(str);
        if (this.values.isEmpty()) {
            return String.valueOf(val);
        }
        float best = Float.MIN_VALUE;
        float bestMismatch = Float.MAX_VALUE;
        for (Float fl : this.getValues()) {
            float mismatch = Math.abs(fl.floatValue() - val);
            if (!(mismatch < bestMismatch)) continue;
            best = fl.floatValue();
            bestMismatch = mismatch;
        }
        if (this.threshold != null && this.threshold.floatValue() > 0.0f && Math.abs(bestMismatch) < this.threshold.floatValue()) {
            return Float.toString(best);
        }
        throw new ParameterException("Closest match for " + super.getKey() + "=" + str + " is " + Float.toString(best) + ", but this exceeds the threshold of " + Float.toString(this.threshold.floatValue()));
    }

    @Override
    @Nullable
    public List<String> getLegalValues() {
        LinkedList<String> ret = new LinkedList<String>();
        Iterator<Float> iter = this.getValues().iterator();
        while (iter.hasNext()) {
            ret.add(Float.toString(iter.next().floatValue()));
        }
        return ret;
    }

    @Override
    public FloatParameterFilter clone() {
        FloatParameterFilter clone = new FloatParameterFilter();
        clone.setDefaultValue(this.getDefaultValue());
        clone.setKey(this.getKey());
        if (this.values != null) {
            clone.values = new ArrayList<Float>(this.values);
        }
        clone.setThreshold(this.threshold);
        return clone;
    }
}

