/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import com.google.common.base.Function;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nullable;

public class CaseNormalizer
implements Function<String, String>,
Serializable,
Cloneable {
    @XStreamAlias(value="case")
    Case kase;
    Locale locale;

    public CaseNormalizer() {
        this(null);
    }

    public CaseNormalizer(Case kase) {
        this(kase, null);
    }

    public CaseNormalizer(Case kase, Locale locale) {
        this.kase = kase;
        this.locale = locale;
    }

    public String apply(String input) {
        return this.getCase().apply(input, this.getLocale());
    }

    public Case getCase() {
        if (this.kase == null) {
            return Case.NONE;
        }
        return this.kase;
    }

    public void setCase(Case kase) {
        this.kase = kase;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    @Nullable
    public Locale getConfiguredLocale() {
        return this.locale;
    }

    public void setConfiguredLocale(@Nullable Locale locale) {
        this.locale = locale;
    }

    public CaseNormalizer clone() {
        return new CaseNormalizer(this.kase, this.locale);
    }

    public static enum Case {
        NONE{

            @Override
            public String apply(String input, Locale loc) {
                return input;
            }
        }
        ,
        UPPER{

            @Override
            public String apply(String input, Locale loc) {
                return input.toUpperCase(loc);
            }
        }
        ,
        LOWER{

            @Override
            public String apply(String input, Locale loc) {
                return input.toLowerCase(loc);
            }
        };


        public abstract String apply(String var1, Locale var2);
    }
}

