/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;

public class XMLGridSubset
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2758612849329765806L;
    private static Log log = LogFactory.getLog(XMLGridSubset.class);
    private String gridSetName;
    private BoundingBox extent;
    private Integer zoomStart;
    private Integer zoomStop;
    private Integer minCachedLevel;
    private Integer maxCachedLevel;

    public XMLGridSubset() {
        this.readResolve();
    }

    private XMLGridSubset readResolve() {
        return this;
    }

    public XMLGridSubset(XMLGridSubset sset) {
        this.setGridSetName(sset.getGridSetName());
        this.setExtent(sset.getExtent() == null ? null : new BoundingBox(sset.getExtent()));
        this.setZoomStart(sset.getZoomStart());
        this.setZoomStop(sset.getZoomStop());
        this.setMinCachedLevel(sset.getMinCachedLevel());
        this.setMaxCachedLevel(sset.getMaxCachedLevel());
    }

    public XMLGridSubset(GridSubset sset) {
        this.setGridSetName(sset.getName());
        this.setExtent(sset.getOriginalExtent() == null ? null : new BoundingBox(sset.getOriginalExtent()));
        this.setZoomStart(sset.getZoomStart());
        this.setZoomStop(sset.getZoomStop());
        this.setMinCachedLevel(sset.getMinCachedZoom());
        this.setMaxCachedLevel(sset.getMaxCachedZoom());
    }

    public XMLGridSubset clone() {
        return new XMLGridSubset(this);
    }

    public GridSubset getGridSubSet(GridSetBroker gridSetBroker) {
        GridSet gridSet = gridSetBroker.get(this.getGridSetName());
        if (gridSet == null) {
            log.error((Object)("Unable to find GridSet for \"" + this.getGridSetName() + "\""));
            return null;
        }
        return GridSubsetFactory.createGridSubSet(gridSet, this.getExtent(), this.getZoomStart(), this.getZoomStop(), this.minCachedLevel, this.maxCachedLevel);
    }

    public String getGridSetName() {
        return this.gridSetName;
    }

    public void setGridSetName(String gridSetName) {
        this.gridSetName = gridSetName;
    }

    public BoundingBox getExtent() {
        return this.extent;
    }

    public void setExtent(BoundingBox extent) {
        this.extent = extent;
    }

    public Integer getZoomStart() {
        return this.zoomStart;
    }

    public void setZoomStart(Integer zoomStart) {
        this.zoomStart = zoomStart;
    }

    public Integer getZoomStop() {
        return this.zoomStop;
    }

    public void setZoomStop(Integer zoomStop) {
        this.zoomStop = zoomStop;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public Integer getMinCachedLevel() {
        return this.minCachedLevel;
    }

    public void setMinCachedLevel(Integer minCachedLevel) {
        this.minCachedLevel = minCachedLevel;
    }

    public Integer getMaxCachedLevel() {
        return this.maxCachedLevel;
    }

    public void setMaxCachedLevel(Integer maxCachedLevel) {
        this.maxCachedLevel = maxCachedLevel;
    }
}

