/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import com.google.common.base.Preconditions;
import org.geowebcache.config.BlobStoreConfig;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.blobstore.file.FileBlobStore;

public class FileBlobStoreConfig
extends BlobStoreConfig {
    private static final long serialVersionUID = -6470560864068854508L;
    private String baseDirectory;
    private int fileSystemBlockSize;

    public FileBlobStoreConfig() {
    }

    public FileBlobStoreConfig(String id) {
        super(id);
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public int getFileSystemBlockSize() {
        return this.fileSystemBlockSize;
    }

    public void setFileSystemBlockSize(int fileSystemBlockSize) {
        this.fileSystemBlockSize = fileSystemBlockSize;
    }

    @Override
    public String toString() {
        return "FileBlobStore[id:" + this.getId() + ", enabled:" + this.isEnabled() + ", baseDirectory:" + this.baseDirectory + "fileSystemBlockSize:" + this.fileSystemBlockSize + ']';
    }

    @Override
    public FileBlobStore createInstance(TileLayerDispatcher layers, LockProvider lockProvider) throws StorageException {
        Preconditions.checkState((this.getId() != null ? 1 : 0) != 0, (Object)"id not set");
        Preconditions.checkState((boolean)this.isEnabled(), (Object)"Can't call FileBlobStoreConfig.createInstance() is blob store is not enabled");
        Preconditions.checkState((this.baseDirectory != null ? 1 : 0) != 0, (Object)"baseDirectory not provided");
        Preconditions.checkState((this.fileSystemBlockSize >= 0 ? 1 : 0) != 0, (String)"fileSystemBlockSize must be a positive integer: %s", (Object[])new Object[]{this.fileSystemBlockSize});
        FileBlobStore fileBlobStore = new FileBlobStore(this.baseDirectory);
        if (this.fileSystemBlockSize > 0) {
            fileBlobStore.setBlockSize(this.fileSystemBlockSize);
        }
        return fileBlobStore;
    }

    @Override
    public String getLocation() {
        return this.getBaseDirectory();
    }
}

