/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.context.WebApplicationContext;

public class GeoWebCacheExtensions
implements ApplicationContextAware,
ApplicationListener {
    public static Log LOGGER = LogFactory.getLog(GeoWebCacheExtensions.class);
    static WeakHashMap<Class<?>, String[]> extensionsCache = new WeakHashMap(40);
    static ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        GeoWebCacheExtensions.context = context;
        extensionsCache.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <T> List<T> extensions(Class<T> extensionPoint, ApplicationContext context) {
        String[] names = GeoWebCacheExtensions.context == context ? extensionsCache.get(extensionPoint) : null;
        if (names == null) {
            GeoWebCacheExtensions.checkContext(context);
            if (context == null) return Collections.emptyList();
            try {
                names = context.getBeanNamesForType(extensionPoint);
                if (GeoWebCacheExtensions.context == context) {
                    extensionsCache.put(extensionPoint, names);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"bean lookup error", (Throwable)e);
                return Collections.emptyList();
            }
        }
        ArrayList<Object> result = new ArrayList<Object>(names.length);
        for (String name : names) {
            Object bean = context.getBean(name);
            result.add(bean);
        }
        return result;
    }

    public static final <T> List<T> extensions(Class<T> extensionPoint) {
        return GeoWebCacheExtensions.extensions(extensionPoint, context);
    }

    public static final Object bean(String name) {
        return GeoWebCacheExtensions.bean(name, context);
    }

    public static final Object bean(String name, ApplicationContext context) {
        GeoWebCacheExtensions.checkContext(context);
        return context != null ? context.getBean(name) : null;
    }

    public static final <T> T bean(Class<T> type) throws IllegalArgumentException {
        GeoWebCacheExtensions.checkContext(context);
        return context != null ? (T)GeoWebCacheExtensions.bean(type, context) : null;
    }

    public static final <T> T bean(Class<T> type, ApplicationContext context) throws IllegalArgumentException {
        List<T> beans = GeoWebCacheExtensions.extensions(type, context);
        if (beans.isEmpty()) {
            return null;
        }
        if (beans.size() > 1) {
            throw new IllegalArgumentException("Multiple beans of type " + type.getName());
        }
        return beans.get(0);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            extensionsCache.clear();
        }
    }

    static void checkContext(ApplicationContext context) {
        if (context == null) {
            LOGGER.fatal((Object)"Extension lookup occured, but ApplicationContext is unset.");
        }
    }

    public static String getProperty(String propertyName) {
        return GeoWebCacheExtensions.getProperty(propertyName, context);
    }

    public static String getProperty(String propertyName, ApplicationContext context) {
        if (context instanceof WebApplicationContext) {
            return GeoWebCacheExtensions.getProperty(propertyName, ((WebApplicationContext)context).getServletContext());
        }
        return GeoWebCacheExtensions.getProperty(propertyName, (ServletContext)null);
    }

    public static String getProperty(String propertyName, ServletContext context) {
        String[] typeStrs = new String[]{"Java environment variable ", "Servlet context parameter ", "System environment variable "};
        String result = null;
        for (int j = 0; j < typeStrs.length; ++j) {
            switch (j) {
                case 0: {
                    result = System.getProperty(propertyName);
                    break;
                }
                case 1: {
                    if (context == null) break;
                    result = context.getInitParameter(propertyName);
                    break;
                }
                case 2: {
                    result = System.getenv(propertyName);
                }
            }
            if (result != null && !result.equalsIgnoreCase("")) break;
            LOGGER.trace((Object)("Found " + typeStrs[j] + ": '" + propertyName + "' to be unset"));
        }
        return result;
    }
}

